/***********************************************************
 * Copyright 2011 VMware, Inc.  All rights reserved.
 * -- VMware Confidential
 ***********************************************************/

package com.vmware.vide.vlogbrowser.service.model;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Class to return a project manifest to a web client.
 * 
 * @author gcaprino
 */

@XmlRootElement(name = "LogBundle")
public class ProjectManifest {
    private String source = ""; // origin of this log file set
    private String bundle = ""; // location of physical bundle
    private long bundleSize = 0; // size in bytes of bundle file
    private String date = ""; // date it was fetched
    private LogFileResult[] logFiles = null;

    public ProjectManifest() {
    }

    @XmlElement
    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    @XmlElement
    public String getDate() {
        return date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    @XmlElement
    public String getBundle() {
        return bundle;
    }
    
    public void setBundle(String bundle) {
        this.bundle = bundle;
    }
    
    @XmlElement
    public long getBundleSize() {
        return bundleSize;
    }
    
    public void setBundleSize(long l) {
        this.bundleSize = l;
    }

    @XmlElement
    public LogFileResult[] getLogFiles() {
        return logFiles;
    }

    public void setLogFiles(LogFileResult[] logFiles) {
        this.logFiles = logFiles;
    }

}
