package com.vmware.samples.actions;

import com.vmware.vise.vim.data.VimObjectReferenceService;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Implementation of the VmActionService interface
 */
public class VmActionServiceImpl implements VmActionService {

   private static final Log _logger =
         LogFactory.getLog(VmActionServiceImpl.class);

   private final VimObjectReferenceService _vimObjectReferenceService;

   /**
    *  Constructor used to inject the utility services (see the declaration
    *  in main/resources/spring/bundle-context-osgi.xml)
    *
    * @param vimObjectReferenceService
    *    Service to access vSphere object references information.
    */
   public VmActionServiceImpl(
            VimObjectReferenceService vimObjectReferenceService) {
      _vimObjectReferenceService = vimObjectReferenceService;
   }

   /* (non-Javadoc)
    * @see com.vmware.samples.actions.VmActionService#backendAction(java.lang.Object)
    */
   public void backendAction(Object vmReference) {
      // All vCenter objects sent from the UI are serialized into an internal type.
      // You can use VimObjectReferenceService to get the right information.
      // See samples/vsphereviews/vsphere-wssdk-provider for an example using
      // the vSphere Web Service SDK to talk to vCenter.
      String type = _vimObjectReferenceService.getResourceObjectType(vmReference);
      String value = _vimObjectReferenceService.getValue(vmReference);
      _logger.info("backendAction called with object type = " + type +
            ", value = " + value);

      // Note: your action processing should take place on the back-end Server,
      // nothing heavy should run in this service on the vSphere Web Client server!
      // If back-end processing takes time it's better to return right away here
      // and let the UI deals with updates later. Otherwise you can return java
      // objects as illustrated in samples/globalview/globalview-service.
   }
}
