package com.vmware.samples.actions {

import com.vmware.actionsfw.ActionContext;
import com.vmware.actionsfw.events.ActionInvocationEvent;
import com.vmware.core.model.IResourceReference;
import com.vmware.flexutil.events.MethodReturnEvent;

import mx.controls.Alert;

/**
* Command class to handle the actions defined in plugin.xml.
* It uses a <code>RequestHandler</code> for each <code>ActionSpec</code>'s uid
*/
public class VmActionCommand {

   // Define a global proxy instance with the InjectableProxy tag
   [InjectableProxy]
   public var proxy:ActionCommandProxy;

   [RequestHandler("com.vmware.samples.actions.myVmAction1")]
   /**
    * Handles the invocation of myVmAction1 by displaying the VM the action is being
    * invoked on.
    */
   public function onVmAction1Invocation(event:ActionInvocationEvent):void {
      var vmReference:IResourceReference = getIResourceReference(event);

      var msg:String = (vmReference != null) ? ("Selected VM is: " + vmReference) :
         "Invalid context!";
      Alert.show(msg);
   }

   [RequestHandler("com.vmware.samples.actions.myVmAction2")]
   /**
    * Handles the invocation of myVmAction2 by calling VmActionService on the server.
    */
   public function onVmAction2Invocation(event:ActionInvocationEvent):void {
      var vmReference:IResourceReference = getIResourceReference(event);
      proxy.backendAction(vmReference, onBackendActionResult);
   }

   [RequestHandler("com.vmware.samples.actions.myVmAction3")]
   /**
    * Handles the invocation of myVmAction3 on template VMs only.
    */
   public function onVmAction3Invocation(event:ActionInvocationEvent):void {
      Alert.show("Action 3 was called on a template VM");
   }

   /**
    * Callback from the VmActionService getSettings method.
    */
   private function onBackendActionResult(event:MethodReturnEvent):void {
      if (event.error != null) {
         Alert.show("Error calling backendAction: " + event.error.message);
         return;
      }
      Alert.show("Action called successfully on the server");
   }

   private function getIResourceReference(event:ActionInvocationEvent):IResourceReference {
      // actionContext.targetObjects is an array of objects on which the action is called
      // so actionContext.targetObjects[0] is the selected VM for this action.
      var actionContext:ActionContext = event.context;
      if (actionContext == null || (actionContext.targetObjects.length <= 0)
            || (!(actionContext.targetObjects[0] is IResourceReference))) {
         return null;
      }
      return (actionContext.targetObjects[0] as IResourceReference);
   }
}
}