package com.vmware.samples.chassisui {

import com.vmware.core.events.ObjectEvent;
import com.vmware.core.model.IResourceReference;
import com.vmware.data.common.OperationType;
import com.vmware.data.common.events.ModelChangeEvent;
import com.vmware.flexutil.events.MethodReturnEvent;
import com.vmware.samples.chassisui.model.ChassisInfo;

import flash.events.EventDispatcher;

import mx.controls.Alert;
import mx.core.FlexGlobals;

[Event(name="{com.vmware.data.common.events.ModelChangeEvent.MODEL_CHANGE}",
      type="com.vmware.data.common.events.ModelChangeEvent")]

/**
 * Singleton manager for handling application-wide events such as WizardCompletionEvent.
 *
 * Implementation notes:
 * - The ChassisEventManager instance is created during initialization in Chassisui.mxml.
 * - A single instance is created and registered to the platform with ObjectEvent, it
 *   will stay alive the rest of the session (by opposition to ChassisActionCommand objects
 *   which are created each time to handle an action invocation event and then are removed).
 */
public class ChassisEventManager extends EventDispatcher {
   // Define a global proxy instance with the InjectableProxy tag
   [InjectableProxy]
   public var proxy:ChassisServiceProxy;

   private static var _instance:ChassisEventManager;

   /**
    * Creates a single instance
    */
   public function ChassisEventManager() {
      if (_instance != null) {
         throw new Error("ChassisEventManager cannot be instantiated more than once.");
      }
      // Registers instance to the platform. Required for supporting [EventHandler].
      FlexGlobals.topLevelApplication.dispatchEvent(ObjectEvent.newAddition(this));
   }

   /**
    * The global instance of this class.
    */
   public static function get instance():ChassisEventManager {
      if (_instance == null) {
         _instance = new ChassisEventManager();
      }
      return _instance;
   }

   [EventHandler(name="{com.vmware.samples.chassisui.WizardCompletionEvent.EVENT_ID}")]
   public function onWizardCompleted(event:WizardCompletionEvent):void {
      if ((event.wizardName == "ChassisWizard") && (event.wizardData is ChassisInfo)) {
         proxy.createChassis(event.wizardData as ChassisInfo, onCreateChassisComplete);
      }
   }

   private function onCreateChassisComplete(event:MethodReturnEvent):void {
      if (event.error != null) {
         Alert.show(event.error.message);
         return;
      }
      if (event.result == null) {
         Alert.show(Util.getString("createAction.error"));
         return;
      }
      // Send a ModelChangeEvent to update the inventory view
      var chassisRef:IResourceReference = event.result as IResourceReference;
      dispatchEvent(ModelChangeEvent.newSingleObjectChangeEvent(chassisRef, OperationType.ADD));
   }

}
}