package com.vmware.samples.chassisui.model {
import com.vmware.core.model.DataObject;

[Bindable]
// Object type associated with this model, must be qualified with a namespace.
[Model(type="samples:Chassis")]
/**
 * Data model for Chassis summary details view.
 */
public class ChassisSummaryDetails extends DataObject {
   // Note: model properties and field names don't need to match.
   // Also, properties within your own type don't require a namespace.

   [Model(property="name")]
   /**
    * Chassis name.
    */
   public var name:String;

   [Model(property="serverType")]
   /**
    * Chassis server type.
    */
   public var serverType:String;
}
}