package com.vmware.samples.chassisui.views {

import com.vmware.samples.chassisui.model.ChassisSummaryDetails;
import com.vmware.core.events.DataRefreshInvocationEvent;
import com.vmware.core.model.IResourceReference;
import com.vmware.data.query.DataUpdateSpec;
import com.vmware.data.query.events.DataByModelRequest;
import com.vmware.ui.IContextObjectHolder;
import com.vmware.data.query.events.DataRequestInfo;

import flash.events.EventDispatcher;

import mx.logging.ILogger;
import mx.logging.Log;

// Declares the data request events sent from the class.
[Event(name="{com.vmware.data.query.events.DataByModelRequest.REQUEST_ID}",
   type="com.vmware.data.query.events.DataByModelRequest")]
/**
 * The mediator for the ChassisSummaryView view.
 */
public class ChassisSummaryViewMediator extends EventDispatcher implements IContextObjectHolder {

   private var _view:ChassisSummaryView;
   private var _contextObject:IResourceReference;

   private static var _logger:ILogger = Log.getLogger('ChassisSummaryViewMediator');

   [View]
   /**
    * The mediator's view.
    */
   public function get view():ChassisSummaryView {
      return _view;
   }

   /** @private */
   public function set view(value:ChassisSummaryView):void {
      _view = value;
   }

   [Bindable]
   public function get contextObject():Object {
      return _contextObject;
   }

   public function set contextObject(value:Object):void {
      _contextObject = IResourceReference(value);

      if (_contextObject == null) {
         clearData();
         return;
      }
      // Initialize the view's data once the current context is known.
      requestData();
   }

   private function requestData():void {
      // Default data request option allowing implicit updates of the view
      var requestInfo:DataRequestInfo =
            new DataRequestInfo(DataUpdateSpec.newImplicitInstance());

      // Dispatch an event to fetch _contextObject data from the server
      // along the specified model.
      dispatchEvent(DataByModelRequest.newInstance(
            _contextObject,
            ChassisSummaryDetails,
            requestInfo));
   }

   /**
    * Handles the server response to DataRequest above.
    *
    * The method name is not important, only its signature and the ResponseHandler tag
    * are, they must match the DataRequest in question. The result is returned with
    * the corresponding model type. The additional error argument was left out here.
    */
   [ResponseHandler(name="{com.vmware.data.query.events.DataByModelRequest.RESPONSE_ID}")]
   public function onData(request:DataByModelRequest, result:ChassisSummaryDetails):void {
      _view.chassisDetails = result;
   }

   /**
    * Handles the global refresh event when the user clicks the Refresh button.
    */
   [EventHandler(name="{com.vmware.core.events.DataRefreshInvocationEvent.EVENT_ID}")]
   public function onGlobalRefreshRequest(event:DataRefreshInvocationEvent):void {
      // _contextObject should be null if the view is not visible
      if (_contextObject != null) {
         requestData();
      } else {
         clearData();
      }
   }

   /**
    * Resets the UI.
    */
   private function clearData() : void {
      _view.chassisDetails = null;
   }
}

}