package com.vmware.samples.chassisrackvsphereui {
import com.vmware.core.model.IResourceReference;
import com.vmware.flexutil.proxies.BaseProxy;
import com.vmware.flexutil.ServiceUtil;
import com.vmware.samples.chassisrackvsphereui.model.ChassisInfo;

/**
 * Proxy class for the java ChassisService.
 */
public class ChassisServiceProxy extends BaseProxy
{
   // This service name must match the flex:remoting-destination in bundle-context.xml
   private static const SERVICE_NAME:String = "chassisService";

   /**
    * Create a ChassisServiceProxy with a secure channel.
    */
   public function ChassisServiceProxy() {
      // channelUri uses the Web-ContextPath defined in MANIFEST.MF
      const channelUri:String = ServiceUtil.getDefaultChannelUri(ChassisRackVSphereUi.contextPath);
      super(SERVICE_NAME, channelUri);
   }

   /**
    * Remove a chassis from the inventory.
    *
    * @param chassisRef    The Chassis reference to be deleted.
    * @param callBack      Optional callback method
    * @param callContext   Optional object that is passed back in the callback method
    */
   public function deleteChassis(
         chassisRef:IResourceReference,
         callback:Function = null,
         context:Object = null):void {
      callService("deleteChassis", [chassisRef], callback, context);
   }

   /**
    * Edit a chassis.
    *
    * @param chassisRef    The Chassis reference to edit.
    * @param callBack      Optional callback method
    * @param callContext   Optional object that is passed back in the callback method
    */
   public function editChassis(
         chassisRef:IResourceReference,
         callback:Function = null,
         context:Object = null):void {
      callService("editChassis", [chassisRef], callback, context);
   }

   /**
    * Add a new chassis to the inventory.
    *
    * @param chassisInfo    The data to create a new chassis.
    * @param rackRef        The rack relation of the new chassis.
    * @param callBack       Optional callback method
    * @param callContext    Optional object that is passed back in the callback method
    */
   public function createChassis(
         chassisInfo:ChassisInfo,
         rackRef:IResourceReference = null,
         callback:Function = null,
         context:Object = null):void {
      callService("createChassis", [chassisInfo, rackRef], callback, context);
   }

   /**
    * Add a host to a chassis.
    *
    * @param hostRef       The host to be added.
    * @param chassisRef    The chassis where to add the host.
    * @param callBack      Optional callback method
    * @param callContext   Optional object that is passed back in the callback method
    */
   public function addHost(
         host:IResourceReference,
         chassisRef:IResourceReference,
         callback:Function = null,
         context:Object = null):void {
      callService("addHost", [host, chassisRef], callback, context);
   }
}
}

