package com.vmware.samples.chassisrackvsphereui.model {

import com.vmware.core.model.DataObject;

[Bindable]
// Declares the type of object associated with this model.
// Types must be qualified with a namespace.
[Model(type="samples:Rack")]
/**
 * Data model for rack summary details view.
 */
public class RackSummaryDetails extends DataObject {
   // Note: Property and field names don't need to match.
   // Also, properties within your own type don't require a namespace.

   [Model(property="name")]
   /**
    * Rack name.
    */
   public var name:String;

   [Model(property="location")]
   /**
    * Rack location.
    */
   public var location:String;
}
}