package com.vmware.samples.globalview {

/**
 * Enum-like Actionscript type implementing the Java Enum equivalent.
 * See SettingEnum.java in globalview-service project.
 */
[Bindable]
[Enum]
[RemoteClass(alias="com.vmware.samples.globalview.SettingEnum")]
public class SettingEnum {
   // Enum objects matching the Java enums
   public static const VAL1:SettingEnum = new SettingEnum("VAL1", true);
   public static const VAL2:SettingEnum = new SettingEnum("VAL2", true);
   public static const VAL3:SettingEnum = new SettingEnum("VAL3", true);

   private var _value:String;
   private var _immutable:Boolean = false;

   public function SettingEnum(val:String = '', immutable:Boolean = false) {
      _value = val;
      _immutable = immutable;
   }

   public function get value():String {
      return _value;
   }

  public function set value(val:String):void {
     if (_immutable) {
        throw new Error(
           'Assertion Error: Cannot update an immutable enum constant field value.');
     }
     _value = val;
  }

  public function equals(another:Object):Boolean {
     if (another is SettingEnum) {
        return (_value == SettingEnum(another).value);
     } else if (another is String) {
        return (_value == String(another));
     }
     return false;
  }

  public function toString():String {
     return Util.getString("settingEnum."+_value);
  }

  public function valueOf():Object {
     return _value;
  }
}
}