package com.vmware.samples.custompropertyui.model {
import com.vmware.core.model.DataObject;

[Bindable]
[RemoteClass(alias="com.vmware.samples.customprovider.EarthLocation")]
/**
 * Flex class mapping to the java type returned by
 * the property provider. Class defining a set of properties retrieved using
 * the custom property provider. This class will define two parameters
 * the latitude and longitude which uniquely identify a location on Earth.
 */
public class EarthLocation extends DataObject {

   /** The Latitude of the location. */
   public var latitude:String;

   /** The Longitude of the location. */
   public var longitude:String;

} // end class
} // end package
