package com.vmware.samples.custompropertyui.views {

import com.vmware.core.model.IResourceReference;
import com.vmware.data.query.events.PropertyRequest;
import com.vmware.samples.custompropertyui.model.EarthLocation;
import com.vmware.samples.custompropertyui.model.ElevationData;
import com.vmware.ui.IContextObjectHolder;

import flash.events.Event;
import flash.events.EventDispatcher;
import flash.events.MouseEvent;

import mx.collections.ArrayCollection;
import mx.controls.Alert;
import mx.formatters.NumberFormatter;

[Event(name="{com.vmware.data.query.events.PropertyRequest.REQUEST_ID}",
      type="com.vmware.data.query.events.PropertyRequest")]
/**
 * The mediator for CustomPropertyHostView.
 */
public class CustomPropertyHostViewMediator extends EventDispatcher implements IContextObjectHolder {

   private var _contextObject:IResourceReference;
   private var _view:CustomPropertyHostView;

   [View]
   /**
    * The mediator's view.
    */
   public function get view():CustomPropertyHostView {
      return _view;
   }

   /** @private */
   public function set view(value:CustomPropertyHostView):void {
      if ((value == null) && (_view != null)) {
         // Release all listeners when the dispose manager removes the view
         _view.getDataButton.removeEventListener(MouseEvent.CLICK, getHostElevationData);
      }

      _view = value;
      if (view != null) {
         _view.getDataButton.addEventListener(MouseEvent.CLICK, getHostElevationData);
         _view.latitudeInput.text = "0";
         _view.longitudeInput.text = "0";
      }
   }


   [Bindable]
   /**
    * Returns the selected host for that view.
    */
   public function get contextObject():Object {
      return _contextObject;
   }

   public function set contextObject(value:Object):void {
      _contextObject = IResourceReference(value);

      // Clear data when showing a new host
      clearData();
   }

   /**
    * Button handler that requests the Host elevation data.
    */
   private function getHostElevationData(click:MouseEvent):void {
      // The property name is qualified with the "samples" namespace as declared
      // in the CustomHostPropertyProvideImpl java class.
      var hostElevationDataRequest:PropertyRequest =
            PropertyRequest.newInstance(_contextObject, "samples:elevationData");

      // Pass the earthLocation input as parameter to the elevationData property
      var earthLocation:EarthLocation = new EarthLocation();
      earthLocation.latitude = _view.latitudeInput.text;
      earthLocation.longitude = _view.longitudeInput.text;
      hostElevationDataRequest.parameter = earthLocation;
      dispatchEvent(hostElevationDataRequest);
   }

   /**
    * This function handles the response to the PropertyRequest
    * that has been dispatched in the getHostElevationData.
    **/
   [ResponseHandler(name=
         "{com.vmware.data.query.events.PropertyRequest.RESPONSE_ID}")]
   public function onHostElevationDataRetrieved(request:PropertyRequest,
            result:Object, error:Error):void {
      if (error != null) {
         Alert.show(error.message);
         return;
      }

       // Assign the result to the vmData bindable variable.
       // This will update the view.
      _view.hostElevationData = result as ElevationData;
   }

   /** Resets the UI */
   private function clearData() : void {
      _view.hostElevationData = null;
   }
} // end class
} // end package
