package com.vmware.samples.viewspropertiesui.model {

import com.vmware.core.model.DataObject;

[Bindable]
[Model(type="VirtualMachine")]
/**
 * A data model of VM Properties to display in the VmSampleMonitorView.
 */
public class VmMonitorData extends DataObject {

    [Model(property="name")]
    /**
     * The name of this VirtualMachine.
     */
    public var name:String;

    [Model(property="runtime.powerState")]
    /**
     * The powerstate of this VirtualMachine.
     */
    public var powerState:String;

    [Model(property="guest.guestState")]
    /**
     * The GuestState of this VirtualMachine.
     */
    public var guestState:String;

    [Model(relation="runtime.host", property="name")]
    /**
      * The host where this VirtualMachine is running.
      * (The relation "runtime.host" gets the VM's HostSystem, and the
      * "name" property applies to that HostSystem reference)
      */
    public var host:String;

    [Model(relation="resourcePool", property="name")]
    /**
      * The resource pool this VirtualMachine is part of.
      * (The relation "resourcePool" gets the VM's ResourcePool, and the
      * "name" property applies to that ResourcePool reference)
      */
    public var resourcePoolName:String;

} // end class
} // end package
