package com.vmware.samples.viewspropertiesui.views {

import com.vmware.samples.viewspropertiesui.QuerySpecUtil;
import com.vmware.samples.viewspropertiesui.model.VmDataItem;
import com.vmware.core.model.IResourceReference;
import com.vmware.data.query.Comparator;
import com.vmware.data.query.Conjoiner;
import com.vmware.data.Constraint;
import com.vmware.data.query.DataUpdateSpec;
import com.vmware.data.query.events.DataRequestInfo;
import com.vmware.data.query.events.DataByConstraintRequest;
import com.vmware.ui.IContextObjectHolder;

import flash.events.Event;
import flash.events.EventDispatcher;
import flash.events.MouseEvent;

import mx.collections.ArrayCollection;
import mx.controls.Alert;
import mx.logging.Log;
import mx.logging.ILogger;

// Meta-tag to register this class as a source of DataByConstraintRequest
[Event(name="{com.vmware.data.query.events.DataByConstraintRequest.REQUEST_ID}",
        type="com.vmware.data.query.events.DataByConstraintRequest")]
/**
 * The mediator for the HostSampleMonitorView.
 */
public class HostSampleMonitorViewMediator extends EventDispatcher
         implements IContextObjectHolder {

   private var _contextObject:IResourceReference;
   private var _view:HostSampleMonitorView;

   private static var _logger:ILogger = Log.getLogger("HostSampleMonitorViewMediator");

   [View]
   /**
    * The mediator's view
    */
   public function get view():HostSampleMonitorView {
      return _view;
   }

   /** @private */
   public function set view(value:HostSampleMonitorView):void {
      _view = value;
   }

   [Bindable]
   /** Returns the selected host for this view */
   public function get contextObject():Object {
      return _contextObject;
   }

   public function set contextObject(value:Object):void {
      _contextObject = IResourceReference(value);

      if (_contextObject == null) {
         clearData();
         return;
      }
      requestData();
   }

   /**
    * Send a query to the server to load the VmDataItem data
    */
   private function requestData():void {

      // Use the data request option for implicit updates of the view,
      // i.e. when the object changes for instance.
      var requestInfo:DataRequestInfo =
         new DataRequestInfo(DataUpdateSpec.newImplicitInstance());

      // Create a constraint for the "vm" relationship on the host object,
      // i.e. this will fetch the list of VMs.
      var vmListConstraint:Constraint =
            QuerySpecUtil.createConstraintForRelationship(
                 _contextObject, "vm", "VirtualMachine");

      // Create a constraint for the "runtime.powerState" property of a VM
      // to keep only VMs where the powerstate is equal to poweredOn.
      var vmPowerStateConstraint:Constraint =
            QuerySpecUtil.createPropertyConstraint(
                "VirtualMachine", "runtime.powerState", Comparator.EQUALS, "poweredOn");

      // Combine the 2 previous constraints with the AND operator, in order
      // to filter the list of VMs with only the ones poweredOn.
      var compositeConstraint:Constraint =
            QuerySpecUtil.createCompositeConstraint(
                 [vmListConstraint, vmPowerStateConstraint], Conjoiner.AND, "VirtualMachine");

      // Send a data request to the server using this compositeConstraint and
      // specifying the VmdataItem model for the properties to retrieve.
      var vmListRequest:DataByConstraintRequest = DataByConstraintRequest.newInstance(
            compositeConstraint, VmDataItem, requestInfo);

      dispatchEvent(vmListRequest);
   }

   /**
    * Handles the response to DataByConstraintRequest above. The method name
    * is not important, only its signature and the ResponseHandler tag are.
    *
    * Note that the result is provided as an Array of VmDataItem since the request
    * was for a list of VMs using the VmDataItem model.
    **/
   [ResponseHandler(name=
         "{com.vmware.data.query.events.DataByConstraintRequest.RESPONSE_ID}")]
   public function onDataRetrieved(request:DataByConstraintRequest,
            result:ArrayCollection, error:Error):void {
      if (error != null) {
         _logger.debug("onDataRetrieved error: " + error.message);
         return;
      }

      // Assigning the result to vmDataItems will update the view.
      _view.vmDataItems = result;
   }

   /** Resets the UI */
   private function clearData() : void {
      _view.vmDataItems = null;
   }
} // end class
} // end package
