package com.vmware.samples.viewspropertiesui.views {

import com.vmware.core.model.IResourceReference;
import com.vmware.data.query.DataUpdateSpec;
import com.vmware.data.query.events.DataByModelRequest;
import com.vmware.data.query.events.DataRequestInfo;
import com.vmware.samples.viewspropertiesui.model.VmMonitorData;
import com.vmware.ui.IContextObjectHolder;

import flash.events.Event;
import flash.events.EventDispatcher;
import flash.events.MouseEvent;

import mx.collections.ArrayCollection;
import mx.controls.Alert;
import mx.logging.ILogger;
import mx.logging.Log;

// Meta-tag to register this class as a source of DataRequest
[Event(name="{com.vmware.data.query.events.DataByModelRequest.REQUEST_ID}",
      type="com.vmware.data.query.events.DataByModelRequest")]
/**
 * The mediator for the VmSampleMonitorView.
 */
public class VmSampleMonitorViewMediator extends EventDispatcher implements IContextObjectHolder {

   private var _contextObject:IResourceReference;
   private var _view:VmSampleMonitorView;

   private static var _logger:ILogger = Log.getLogger("VmSampleMonitorViewMediator");

   [View]
   /**
    * The mediator's view
    */
   public function get view():VmSampleMonitorView {
      return _view;
   }

   /** @private */
   public function set view(value:VmSampleMonitorView):void {
      _view = value;
   }

   [Bindable]
   /** Returns the selected VM for this view */
   public function get contextObject():Object {
      return _contextObject;
   }

   public function set contextObject(value:Object):void {
      _contextObject = IResourceReference(value);

      if (_contextObject == null) {
         clearData();
         return;
      }
      requestData();
   }

   /** Send a query to the server to load the VM data for the selected VM */
   private function requestData():void {
      // Use the data request option for implicit updates of the view,
      // i.e. when the object changes for instance.
      var requestInfo:DataRequestInfo =
         new DataRequestInfo(DataUpdateSpec.newImplicitInstance());

      // Use a DataByModelRequest to get the properties defined in VmMonitorData
      var vmdatarequest:DataByModelRequest = DataByModelRequest.newInstance(
            _contextObject, VmMonitorData, requestInfo);
      dispatchEvent(vmdatarequest);
   }

   /**
    * Handles the response to DataByModelRequest above. The method name is not
    * important, only its signature and the ResponseHandler tag are.
    *
    * Note that the result is provided with the same VmMonitorData type as
    * the requested model.
    **/
   [ResponseHandler(name=
         "{com.vmware.data.query.events.DataByModelRequest.RESPONSE_ID}")]
   public function onVmDataRetrieved(request:DataByModelRequest,
            result:VmMonitorData, error:Error):void {
      if (error != null) {
         _logger.debug("onVmDataRetrieved error: " + error.message);
         return;
      }

      // Assigning the result to datastoreItems will update the view.
      _view.vmData = result;
   }

   /** Resets the UI */
   private function clearData() : void {
      _view.vmData = null;
   }
} // end class
} // end package

