package com.vmware.samples.wssdkui.model {
import com.vmware.core.model.DataObject;

[Bindable]
[RemoteClass(alias="com.vmware.samples.wssdkprovider.VmData")]
/**
 * A data model of VM properties to display.
 * This Flex class maps to the VmData java type returned by
 * the property provider in vsphere-wssdk-provider.
 */
public class VmData extends DataObject {
   /** The DataCenter name this VM resides on. */
   public var datacenterName:String;

   /** Number of virtual CPUs present in this VM. */
   public var numberOfVirtualCpus:String;

   /** Capacity in KB for this VM's VirtualDisk. */
   public var capacityInKb:String;

} // end class
} // end package
