@echo off
REM --- Windows script to build all samples

@setlocal
@IF not defined ANT_HOME (
   @echo You must set the env variable ANT_HOME to your Apache Ant folder
   goto end
)
@IF not defined VSPHERE_SDK_HOME (
   @echo BUILD FAILED: You must set the env variable VSPHERE_SDK_HOME to your vSphere Client SDK folder
   goto end
)
@IF not defined FLEX_HOME (
   @echo Using the Adobe Flex SDK files bundled with the vSphere Client SDK
   @set FLEX_HOME=%VSPHERE_SDK_HOME%\resources\flex_sdk_4.6.0.23201_vmw
)
@IF not exist "%VSPHERE_SDK_HOME%\libs\vsphere-client-lib.jar" (
   @echo VSPHERE_SDK_HOME is not set to a valid vSphere Web Client SDK folder
   @echo %VSPHERE_SDK_HOME%\libs\vsphere-client-lib.jar is missing
   goto end
)

@call "%ANT_HOME%\bin\ant" -f build-all.xml

@echo.
@echo "Note: if Ant runs out of memory set ANT_OPTS=-Xms768m -Xmx1024m -XX:MaxPermSize=256m"
:end
