// Use JQuery's $(document).ready to execute the script when the document is loaded.
// All variables and functions are also hidden from the global scope.

$(document).ready(function() {
   // Namespace shortcut
   var ns = com_vmware_samples_chassisa;

   // Get current object and return if document is loaded before context is set
   var objectId = WEB_PLATFORM.getObjectId();
   if (!objectId) {
      return;
   }
   // Data url to get 3 chassis properties
   var dataUrl = ns.buildDataUrl(objectId, ["name", "dimensions", "serverType"]);

   // The view refreshData function calls to the DataAccessController and returns
   // Json data to insert in the document.
   function refreshData() {
      $.getJSON(dataUrl, function(data) {
         var items = [];
         $.each(data, function(key, val) {
            if (key !== "id") {
               var label = ns.getString(key+'Label');
               items.push('<li id="' + key + '"><b>'+ label +'</b> '+ val +'</li>');
            }
            if (key === "name") {
               // Pass chassis name as parameter in the title string
               var title = ns.getString("summary.title", [val]);
               // Add the accordion arrow icon to the title
               $("#title").html(function(index) {
                  return "<span class='ui-accordion-header-icon ui-icon ui-icon-triangle-1-s'></span>"
                     + title;
               });
            }
         });
         $('#main-info').html("");
         $('<ul/>', {
           'class': 'my-new-list',
           html: items.join('')
         }).appendTo('#main-info');
      })
      .fail(function(jqXHR, status, error) {
         // Use the response from handleException() in the java controller
         var response = jqXHR.responseJSON;
         alert("refreshData failed: " + response.message +
               "\nCause: " + response.cause);
      });
   }
   // Do the actual call now and save as GlobalRefresh handler
   refreshData();
   WEB_PLATFORM.setGlobalRefreshHandler(refreshData);

   // Use strings from resource bundle
   $("#details").text(ns.getString("summary.details"));
   $("#add-content").text(ns.getString("summary.addContent"));
   $("#more-info").text(ns.getString("summary.moreInfo"));
   $("#monitorLink").text(ns.getString("monitor.view1"));
   $("#manageLink").text(ns.getString("manage.view1"));
   $("#dialog-example").text(ns.getString("summary.dialogExample"));
   $("#editChassisLink").text(ns.getString("chassis.editAction"));

   // Must re-use oldhtml which contains the accordion arrow icon
   var detailsText = ns.getString("summary.details");
   $("#details1").html(function(index, oldhtml) {
      return oldhtml + detailsText;
   });
   $("#details2").html(function(index, oldhtml) {
      return oldhtml + detailsText;
   });

   // Navigate to another view using its extension id.
   $("#monitorLink").click(function() {
      WEB_PLATFORM.sendNavigationRequest("com.vmware.samples.chassisa.MonitorView1", objectId);
   });
   $("#manageLink").click(function() {
      WEB_PLATFORM.sendNavigationRequest("com.vmware.samples.chassisa.ManageView1", objectId);
   });

   // Example of a modal dialog opened outside the HTML view, not constrained in size,
   // for instance a wizard for which you need the rest of the application to be blocked.
   // (The only drawback is that the HTML view will disappear temporarily).
   $("#editChassisLink").click(function() {
      // The objectId parameter is required only because editChassisDialog.js uses
      // WEB_PLATFORM.callActionsController to perform an action on that object.
      var url = "chassisa/resources/editChassisDialog.html";
      WEB_PLATFORM.openModalDialog("Edit Chassis", url, 490, 240, objectId);
   });

   // Define a callback that could be used by a modal dialog.  We must use a namespace in
   // the top window because the view and dialog document are in different iframes.
   if (!window.top.com_vmware_samples_chassisa) {
      window.top.com_vmware_samples_chassisa = {};
   }
   window.top.com_vmware_samples_chassisa.chassisCallback = function (message) {
      alert(message);
   };

});
