// Shared code for creating or editing a chassis. This is used by the editChassiAction popup
// defined in action extensions com.vmware.samples.chassisa.editChassis and
// com.vmware.samples.chassisa.createChassis

$(document).ready(function() {

   // Namespace shortcut
   var ns = com_vmware_samples_chassisa;

   // actionUid is one of the parameters passed to UI action dialogs
   var actionUid = WEB_PLATFORM.getActionUid();
   var isNewChassis = (actionUid == "com.vmware.samples.chassisa.createChassis");

   // Set the title dynamically based on the type of action
   WEB_PLATFORM.setDialogTitle(ns.getString(isNewChassis ? 'chassis.createAction' : 'chassis.editAction'));

   // Submit button will send form data in JSON format
   $("#editForm").submit(function() {
      var $form = $( this ),
         json = $form.serializeJson(),
         url = $form.attr('action') + "?actionUid=" + actionUid;

      // This calls the java ActionsController which will update the chassis data and return
      // an ActionResult to the platform so that it can update the UI data model.
      WEB_PLATFORM.callActionsController(url, json);

      // Dialog must be closed, the action callback cannot be handled here
      WEB_PLATFORM.closeDialog();
      return false;
   });

   // Use strings from resource bundle
   var keyPrefix = isNewChassis ? "create": "edit";
   $("#header").html("<center>"+ ns.getString(keyPrefix + ".header") + "</center>");
   $("#name").text(ns.getString("name"));
   $("#serverType").text(ns.getString("serverType"));
   $("#dimensions").text(ns.getString("dimensions"));
   $("#submit").text(ns.getString(keyPrefix + ".submit"));
   $("#cancel").text(ns.getString("cancel"));

   // Initialize input fields with existing values
   if (!isNewChassis) {
      var objectId = WEB_PLATFORM.getActionTargets();
      if (!objectId) {
         return;
      }
      // Prepare data url for the 3 chassis properties
      var dataUrl = ns.buildDataUrl(objectId, ["name", "dimensions", "serverType"]);

      $.getJSON(dataUrl, function(data) {
         $.each(data, function(key, val) {
            if (key != "id") {
               $("input[name='"+key+"']").val(val);
            }
         });
      });
   }
});
