// This code is slightly different from editChassisAction.js because it is not used for
// a popup defined as action extension. This is an example of "external" dialog opened
// from a view, i.e. a real modal dialog box that blocks the application and is not
// constrained by the view's boundaries like an "embedded" html popup would be.

$(document).ready(function() {

   // Namespace shortcut
   var ns = com_vmware_samples_chassisa;

   var actionUid = "com.vmware.samples.chassisa.editChassis";

   // Submit button will send the form data in JSON format
   $("#editForm").submit(function() {
      var $form = $( this ),
         json = $form.serializeJson(),
         url = $form.attr('action') + "?actionUid=" + actionUid;

      // This calls the java ActionsController which will update the chassis data and return
      // an ActionResult to the platform so that it can update the UI data model.
      WEB_PLATFORM.callActionsController(url, json);

      // Dialog must be closed, the action callback is not handled here
      WEB_PLATFORM.closeDialog();
      return false;
   });

   // Cancel button handler
   $("#cancel").click(function() {
      // Example of a callback to the calling view (chassis-summary) using a global namespace
      window.top.com_vmware_samples_chassisa.chassisCallback("cancelling");

      WEB_PLATFORM.closeDialog();
   });

   // Use strings from resource bundle
   $("#header").html("<center>"+ ns.getString("edit.header") + "</center>");
   $("#name").text(ns.getString("name"));
   $("#serverType").text(ns.getString("serverType"));
   $("#dimensions").text(ns.getString("dimensions"));
   $("#submit").text(ns.getString("edit.submit"));
   $("#cancel").text(ns.getString("cancel"));

   // Initialize input fields with existing values for that chassis object
   var objectId = WEB_PLATFORM.getObjectId();
   var dataUrl = ns.buildDataUrl(objectId, ["name", "dimensions", "serverType"]);

   $.getJSON(dataUrl, function(data) {
     $.each(data, function(key, val) {
        if (key != "id") {
           $("input[name='"+key+"']").val(val);
        }
     });
  });

});
