/* Copyright 2012 VMware, Inc. All rights reserved. -- VMware Confidential */
package com.vmware.samples.chassisa;

import com.vmware.samples.chassisa.model.ChassisInfo;

/**
 * Interface to perform operations on the Chassis object.
 */
public interface ChassisService {
   /**
    * Creates a new chassis with the given chassisInfo values.
    *
    * @param chassisInfo
    *    Chassis data used to create new Chassis.
    *
    * @return
    *    Returns the reference of the newly created Chassis,
    *    or null if the creation failed because the name was already taken.
    */
   Object createChassis(ChassisInfo chassisInfo);

   /**
    * Update a chassis object with given chassisInfo data.
    *
    * @param chassisReference Chassis reference.
    *
    * @param newInfo
    *    Chassis data for the update.
    *
    * @return true if the Chassis was updated successfully.
    */
   boolean updateChassis(Object chassisReference, ChassisInfo newInfo);

   /**
    * Deletes the given chassis object.
    *
    * @param chassisReference Chassis reference.
    * @return true if the Chassis was deleted successfully.
    */
   boolean deleteChassis(Object chassisReference);

}
