// Use JQuery's $(document).ready to execute the script when the document is loaded.
// All variables and functions are also hidden from the global scope.

$(document).ready(function() {
   // Namespace shortcut
   var ns = com_vmware_samples_chassisb;

   // Get current object and return if document is loaded before context is set
   var objectId = WEB_PLATFORM.getObjectId();
   if (!objectId) {
      return;
   }
   // Data url to get 3 chassis properties
   var dataUrl = ns.buildDataUrl(objectId, ["name", "dimensions", "serverType"]);

   // The view refreshData function calls to the DataAccessController and returns
   // Json data to insert in the document.
   function refreshData() {
      $.getJSON(dataUrl, function(data) {
         var items = [];
         $.each(data, function(key, val) {
            if (key !== "id") {
               var label = ns.getString(key+'Label');
               items.push('<li id="' + key + '"><b>'+ label +'</b> '+ val +'</li>');
            }
            if (key === "name") {
               // Pass chassis name as parameter in the title string
               var title = ns.getString("summary.title", [val]);
               // Add the accordion arrow icon to the title
               $("#title").html(function(index, oldhtml) {
                  return "<span class='ui-accordion-header-icon ui-icon ui-icon-triangle-1-s'></span>"
                  + title;
               });
            }
         });
         $('#main-info').html("");
         $('<ul/>', {
           'class': 'my-new-list',
           html: items.join('')
         }).appendTo('#main-info');
      })
      .fail(function(jqXHR, status, error) {
         // Use the response from handleException() in the java controller
         var response = jqXHR.responseJSON;
         alert("refreshData failed: " + response.message +
               "\nCause: " + response.cause);
      });
   }
   // Do the actual call now and save as GlobalRefresh handler
   refreshData();
   WEB_PLATFORM.setGlobalRefreshHandler(refreshData);

   // Use strings from resource bundle
   $("#details").text(ns.getString("summary.details"));
   $("#add-content").text(ns.getString("summary.addContent"));
   $("#more-info").text(ns.getString("summary.moreInfo"));
   $("#monitorLink").text(ns.getString("monitor.view1"));
   $("#manageLink").text(ns.getString("manage.view1"));

   // Must re-use oldhtml which contains the accordion arrow icon
   var detailsText = ns.getString("summary.details");
   $("#details1").html(function(index, oldhtml) {
      return oldhtml + detailsText;
   });
   $("#details2").html(function(index, oldhtml) {
      return oldhtml + detailsText;
   });

   // Navigate to another view using its extension id.
   $("#monitorLink").click(function() {
      WEB_PLATFORM.sendNavigationRequest("com.vmware.samples.chassisb.MonitorView1", objectId);
   });
   $("#manageLink").click(function() {
      WEB_PLATFORM.sendNavigationRequest("com.vmware.samples.chassisb.ManageView1", objectId);
   });

});


