// Shared code for creating or editing a chassis
$(document).ready(function() {

   // Namespace shortcut
   var ns = com_vmware_samples_chassisb;

   var actionUid = WEB_PLATFORM.getActionUid();
   var isNewChassis = (actionUid == "com.vmware.samples.chassisb.createChassis");

   // Submit button will send form data in JSON format
   $("#editForm").submit(function() {
      var $form = $( this ),
         json = $form.serializeJson(),
         url = $form.attr('action') + "?actionUid=" + actionUid;

      WEB_PLATFORM.callActionsController(url, json);

      // Dialog must be closed, the action callback is not handled here
      WEB_PLATFORM.closeDialog();
      return false;
   });

   // Use strings from resource bundle
   var keyPrefix = isNewChassis ? "create": "edit";
   $("#header").html(ns.getString(keyPrefix + ".header"));
   $("#name").text(ns.getString("name"));
   $("#serverType").text(ns.getString("serverType"));
   $("#dimensions").text(ns.getString("dimensions"));
   $("#submit").text(ns.getString(keyPrefix + ".submit"));
   $("#cancel").text(ns.getString("cancel"));

   // Initialize input fields with existing values
   if (!isNewChassis) {
      var objectId = WEB_PLATFORM.getActionTargets();
      if (!objectId) {
         return;
      }
      // Prepare data url for the 3 chassis properties
      var dataUrl = ns.buildDataUrl(objectId, ["name", "dimensions", "serverType"]);

      $.getJSON(dataUrl, function(data) {
         $.each(data, function(key, val) {
            if (key != "id") {
               $("input[name='"+key+"']").val(val);
            }
         });
      });
   }
});
