/** Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */

package com.vmware.samples.chassisb;

import java.net.URI;

import com.vmware.samples.chassisb.model.ChassisInfo;

/**
 * Interface to perform operations on the Chassis object.
 */
public interface ChassisService {
   /**
    * Creates a new chassis with the given chassisInfo values.
    *
    * @param chassisInfo
    *    Chassis data used to create new Chassis.
    * @param rackRef
    *    Reference to the rack the new chassis will be related to, or null
    *    if there will be no relation.
    *
    * @return
    *    Returns the URI reference of the newly created Chassis,
    *    or null if the creation failed because the name was already taken.
    */
   URI createChassis(ChassisInfo chassisInfo, URI rackRef);

   /**
    * Update a chassis object with given chassisInfo data.
    *
    * @param chassisRef Chassis reference.
    *
    * @param newInfo
    *    Chassis data for the update.
    *
    * @return true if the Chassis was updated successfully.
    */
   boolean updateChassis(URI chassisRef, ChassisInfo newInfo);

   /**
    * Delete the given chassis object.
    *
    * @param chassisRef  Chassis reference.
    * @return true if the chassis was deleted successfully.
    */
   boolean deleteChassis(URI chassisRef);

   /**
    * Add a host to a chassis if it wasn't present already. This also removes the host
    * from its previous chassis if any.
    *
    * @param hostRef
    *       Host object reference, i.e. must be handled by a VimObjectReferenceService
    * @param chassisRef
    *       Chassis reference, i.e. must be handled by an ObjectReferenceService
    * @return true if the host was added to the chassis.
    */
   boolean addHost(Object hostRef, URI chassisRef);

}
