$(document).ready(function() {
   // Namespace shortcut
   var ns = com_vmware_samples_h5_globalview;

   $("#clientInfo").text(
      "Current vSphere Client: " + WEB_PLATFORM.getClientType() +
      " " + WEB_PLATFORM.getClientVersion());

   $("#helloBtn").click(function() {
     // Call EchoService and display the identical message being returned
     var echoServiceUrl = ns.webContextPath + "/rest/services/echo";
     var msg = ns.getString("mainView.world");
     $.post(echoServiceUrl, { message: msg},
         function(echoStr) {
            alert(echoStr);
         })
         .fail(function(jqXHR, status, error) {
            var response = jqXHR.responseJSON;
            alert( "echoService failed: " + response.message +
                  "\nCause: " + response.cause);
         });

   });

   // Navigate to other views using their extensionId
   $("#gotoSettings").click(function() {
      WEB_PLATFORM.sendNavigationRequest("com.vmware.samples.h5.globalview.settingView");
   });
   $("#gotoVCenter").click(function() {
      WEB_PLATFORM.sendNavigationRequest("com.vmware.samples.h5.globalview.vcView");
   });

   // Use strings from resource bundle
   $("#clickToCall").text(ns.getString("mainView.clickToCall"));
   $("#helloBtn").text(ns.getString("mainView.helloBtn"));
   $("#gotoSettings").text(ns.getString("mainView.gotoSettings"));
   $("#gotoVCenter").text(ns.getString("mainView.gotoVCenter"));

});
