$(document).ready(function() {
   // Namespace shortcut
   var ns = com_vmware_samples_h5_globalview;

   $("#updateMsg").hide();

   // Initialize the form data
   var getUrl = ns.webContextPath + "/rest/services/getSettings";
   $.getJSON(getUrl, function(data) {
      $.each(data, function(key, val) {
         if (key === "setting3") {
            $("input[name='"+key+"'][value='"+val+"']").prop('checked', true);
         }
         else {
            $("input[name='"+key+"']").val(val);
         }
      });
   })
   .fail(function(jqXHR, status, error) {
      alert( "Error retrieving data: " + error );
   });

   // Submit button sends form data in Json format
   $("#settingsForm").submit(function() {
      var $form = $(this),
         json = $form.serializeJson(),
         saveUrl = ns.webContextPath + "/rest/services/saveSettings";

      $.post(saveUrl, { json : json }, function() {
         $("#updateMsg").show();
      })
      .fail(function(jqXHR, status, error) {
         var response = jqXHR.responseJSON;
         alert( "Update failed: " + response.message +
               "\nCause: " + response.cause);
         $("#updateMsg").hide();
      });
      // return false is required to cancel the default submit event!
      return false;
   });

   // Navigate to other views using their extensionId
   $("#gotoMain").click(function() {
      WEB_PLATFORM.sendNavigationRequest("com.vmware.samples.h5.globalview.mainView");
   });

   // TODO Use strings from resource bundle

});

// Utility to serialize form data into a Json object
(function($,undefined){
$.fn.serializeJson = function(){
  var obj = {};
  $.each( this.serializeArray(), function(i,o){
      var n = o.name,
      v = o.value;
      obj[n] = (obj[n] === undefined) ? v
        : $.isArray( obj[n] ) ? obj[n].concat( v )
        : [ obj[n], v ];
  });
  return JSON.stringify(obj);
};
})(jQuery);
