/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */

package com.vmware.samples.wssdkui.model {
import com.vmware.core.model.DataObject;

[Bindable]
[RemoteClass(alias="com.vmware.samples.vspherewssdk.model.HostData")]
/**
 * A data model of Host properties to display.
 * This Flex class maps to the HostData java type returned by
 * the property provider in vsphere-wssdk-service.
 */
public class HostData extends DataObject {
   /** The name of this host. */
   public var name:String;

   /** The IP address of this host. */
   public var ipAddress:String;

   /** Unique ID of this host. */
   public var uuid:String;

} // end class
} // end package
