/* Copyright 2012 VMware, Inc. All rights reserved. -- VMware Confidential */

package com.vmware.samples.wssdkui.views {

import com.vmware.core.model.IResourceReference;
import com.vmware.data.query.events.PropertyRequest;
import com.vmware.samples.wssdkui.model.VmData;
import com.vmware.ui.IContextObjectHolder;

import flash.events.Event;
import flash.events.EventDispatcher;
import flash.events.MouseEvent;

import mx.collections.ArrayCollection;
import mx.controls.Alert;
import mx.logging.ILogger;
import mx.logging.Log;

// Declares the DataService events sent by this class.
[Event(name="{com.vmware.data.query.events.PropertyRequest.REQUEST_ID}",
       type="com.vmware.data.query.events.PropertyRequest")]
/**
 * The mediator for VsphereWsSdkVmMonitorView.
 */
public class VsphereWsSdkVmMonitorViewMediator extends EventDispatcher
         implements IContextObjectHolder {

   private var _contextObject:IResourceReference;
   private var _view:VsphereWsSdkVmMonitorView;
   private static var _logger:ILogger = Log.getLogger("VsphereWsSdkVmMonitorViewMediator");

   [View]
   /**
    * The mediator's view.
    */
   public function get view():VsphereWsSdkVmMonitorView {
      return _view;
   }

   /** @private */
   public function set view(value:VsphereWsSdkVmMonitorView):void {
      _view = value;
   }

   [Bindable]
   public function get contextObject():Object {
      return _contextObject;
   }

   public function set contextObject(value:Object):void {
      _contextObject = IResourceReference(value);

      if (_contextObject == null) {
         clearData();
         return;
      }
      requestData();
   }

   /**
    * Send a query to the server to load the vmData data
    */
   private function requestData():void {
      // Requests a single property called "samples:vmData". This will be
      // handled on the server side by the DataProviderImpl class.
      //
      // Note: This is an asynchronous call: the response may take some time and
      // the view will be grayed out temporarily.
      var myVmInfoRequest:PropertyRequest =
            PropertyRequest.newInstance(_contextObject, "samples:vmData");
      dispatchEvent(myVmInfoRequest);
   }

   /**
    * Handles the response to PropertyRequest above. The method name
    * is not important, only its signature and the ResponseHandler tag are.
    *
    * Note that the result is returned as a VmData type since it is the type
    * returned by the getVmData method in VmPropertyProviderImpl.
    */
   [ResponseHandler(name="{com.vmware.data.query.events.PropertyRequest.RESPONSE_ID}")]
   public function onDataRetrieved(request:PropertyRequest,
            result:Object, error:Error):void {
      if (error != null) {
         _logger.debug("onDataRetrieved error: " + error);
         return;
      }

      // Assigning the result to vmData will update the view.
      _view.vmData = result as VmData;
   }

   /** Resets the UI */
   private function clearData() : void {
      _view.vmData = null;
   }
} // end class
} // end package
