// Use JQuery's $(document).ready to execute the script when the document is loaded.
// All variables and functions are also hidden from the global scope.

$(document).ready(function() {
   // Namespace shortcut
   var ns = com_vmware_samples_vspherewssdk;

   // Get current object and return if document is loaded before context is set
   var objectId = WEB_PLATFORM.getObjectId();
   if (!objectId) {
      return;
   }

   var HOSTDATA_PROPERTY = "samples:hostData";
   var VMDATA_PROPERTY = "samples:vmData";

   // REST url to retrieve a list of properties
   var dataUrl = ns.buildDataUrl(objectId, [HOSTDATA_PROPERTY, VMDATA_PROPERTY]);

   // JQuery call to the DataAccessController in the Java plugin
   $.getJSON(dataUrl, function(data) {
      // The "sample:hostData" property is an object containing the HostData field
      var hostData = data[HOSTDATA_PROPERTY];
      // The "sample:vmData" property is an object containing the VmData field
      var vmData = data[VMDATA_PROPERTY];

      $("#hostInfo").html(
            "<p><b>Host Name: </b>" + escape(hostData.name) +
            "<p><b>Host IP: </b>" + hostData.ipAddress +
            "<p><b>Host UUID: </b>" + hostData.uuid);

      $("#vmInfo").html(
            !vmData.vmName ? "No Virtual Machine found" :
            "<p>First Virtual Machine found:</p>" +
            "<p><b>VM Name: </b>" + escape(vmData.vmName) +
            "<p><b>Virtual CPUs: </b>" + vmData.numberOfVirtualCpus +
            "<p><b>Disk Capacity: </b>" + vmData.capacityInKb + "</p>");
   });
});

//It is recommended to escape user-entered names.
function escape(string) {
   return $("<div>").text(string).html();
}
