$(document).ready(function() {

   // Namespace shortcut
   var ns = com_vmware_samples_vspherewssdk;

   // actionUid is one of the parameters passed to UI action dialogs
   var actionUid = WEB_PLATFORM.getActionUid();

   // Submit button will send form data in JSON format
   $("#editForm").submit(function() {
      var $form = $( this ),
         json = $form.serializeJson(),
         url = $form.attr('action') + "?actionUid=" + actionUid;

      // This calls the java ActionsController which will update the chassis data and return
      // an ActionResult to the platform so that it can update the UI data model.
      WEB_PLATFORM.callActionsController(url, json);

      // Dialog must be closed, the action callback cannot be handled here
      WEB_PLATFORM.closeDialog();
      return false;
   });
});

// Utility to serialize a form into Json data
// See http://benalman.com/projects/jquery-misc-plugins/#serializeobject
(function($,undefined){
   $.fn.serializeJson = function(){
      var obj = {};
      $.each( this.serializeArray(), function(i,o){
         var n = o.name,
               v = o.value;
         obj[n] = (obj[n] === undefined) ? v
               : $.isArray( obj[n] ) ? obj[n].concat( v )
               : [ obj[n], v ];
      });
      return JSON.stringify(obj);
   };
})(jQuery);
