// Use JQuery's $(document).ready to execute the script when the document is loaded.
// All variables and functions are also hidden from the global scope.

$(document).ready(function() {
   // Namespace shortcut
   var ns = com_vmware_samples_vspherewssdk;

   // Get current object and return if document is loaded before context is set
   var objectId = WEB_PLATFORM.getObjectId();
   if (!objectId) {
      return;
   }

   // REST url to retrieve a list of properties
   var dataUrl = ns.buildDataUrl(objectId, ["samples:vmData"]);

   // JQuery call to the DataAccessController in the Java plugin
   $.getJSON(dataUrl, function(data) {
      // The "sample:vmData" property is an object containing the VmData field
      var vmData = data["samples:vmData"];
      $("#vmInfo").html(
            "<p><b>Virtual Machine Name: </b>" + escape(vmData.vmName) +
            "<p><b>Data Center Name: </b>" + escape(vmData.datacenterName) +
            "<p><b>Virtual CPUs: </b>" + vmData.numberOfVirtualCpus +
            "<p><b>Disk Capacity: </b>" + vmData.capacityInKb + "</p>");
   });
});

// It is recommended to escape user-entered names to avoid persistent XSS.
function escape(string) {
   return $("<div>").text(string).html();
}
