package com.vmware.samples.vspherewssdk;

import com.vmware.samples.vspherewssdk.model.VmInfo;
/**
 * Service handling the plugin VM actions
 */
public interface VmActionService {
   /**
    * Sample action1 called on the server.
    *
    * @param vmReference
    *    Internal reference to the VM object for that action.
    * @param vmInfo
    *    User-provided data to perform that action
    *
    * @return true if the action succeeds, false otherwise
    */
   public boolean backendAction1(Object vmReference, VmInfo vmInfo);

   /**
    * Sample action2 called on the server.
    * Note that no additional parameters are used since this is for a headless action
    *
    * @param vmReference
    *    Internal reference to the VM object for that action.
    *
    * @return true if the action succeeds, false otherwise
    */
   public boolean backendAction2(Object vmReference);
}
