package com.vmware.samples.vspherewssdk;

import com.vmware.samples.vspherewssdk.model.VmInfo;
import com.vmware.vise.vim.data.VimObjectReferenceService;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Implementation of the VmActionService interface
 */
public class VmActionServiceImpl implements VmActionService {

   private static final Log _logger =
         LogFactory.getLog(VmActionServiceImpl.class);

   private final VimObjectReferenceService _vimObjectReferenceService;

   /**
    * Constructor used to inject the utility services (see the declaration
    * in main/resources/spring/bundle-context-osgi.xml)
    *
    * @param vimObjectReferenceService Service to access vSphere object references information.
    */
   public VmActionServiceImpl(
         VimObjectReferenceService vimObjectReferenceService) {
      _vimObjectReferenceService = vimObjectReferenceService;
   }

   /* (non-Javadoc)
    * @see com.vmware.samples.actions.VmActionService#backendAction1(java.lang.Object)
    */
   public boolean backendAction1(Object vmReference, VmInfo vmInfo) {
      // All vCenter objects sent from the UI are serialized into an internal type.
      // Use VimObjectReferenceService to get more information.
      // See DataProviderImpl.java for an example using the vSphere Web Services SDK
      // to talk to vCenter.
      String type = _vimObjectReferenceService.getResourceObjectType(vmReference);
      String value = _vimObjectReferenceService.getValue(vmReference);
      _logger.info("backendAction1 called with object type = " + type + ", value = " + value
         + ", param1 = " + vmInfo.param1 + ", param2 = " + vmInfo.param2);

      // TODO: action processing should take place on the back-end Server,
      // nothing heavy should run in this service on the vSphere Client server.
      // If back-end processing takes time it's better to return right away here
      // and let the UI deals with updates later.

      return true;
   }

   /* (non-Javadoc)
    * @see com.vmware.samples.actions.VmActionService#backendAction2(java.lang.Object)
    */
   public boolean backendAction2(Object vmReference) {
      String type = _vimObjectReferenceService.getResourceObjectType(vmReference);
      String value = _vimObjectReferenceService.getValue(vmReference);
      _logger.info("backendAction2 called with object type = " + type +
            ", value = " + value);

      // TODO: action processing should take place on the back-end Server.

      // Returning false is as an example to trigger an error message in the UI.
      return false;
   }
}