/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.bizapp.agent.server;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Properties;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentAPIInfo;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.hq.agent.AgentConfigException;
import org.hyperic.hq.agent.AgentKeystoreConfig;
import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.AgentRemoteValue;
import org.hyperic.hq.agent.AgentStartupCallback;
import org.hyperic.hq.agent.server.AgentConnectionListener;
import org.hyperic.hq.agent.server.AgentDaemon;
import org.hyperic.hq.agent.server.AgentNotificationHandler;
import org.hyperic.hq.agent.server.AgentServerHandler;
import org.hyperic.hq.agent.server.AgentStartException;
import org.hyperic.hq.agent.server.AgentStorageException;
import org.hyperic.hq.agent.server.AgentStorageProvider;
import org.hyperic.hq.bizapp.agent.CommandsAPIInfo;
import org.hyperic.hq.bizapp.agent.ProviderInfo;
import org.hyperic.hq.bizapp.agent.TokenData;
import org.hyperic.hq.bizapp.agent.TokenManager;
import org.hyperic.hq.bizapp.agent.TokenStorer;
import org.hyperic.hq.bizapp.agent.commands.CreateToken_args;
import org.hyperic.hq.bizapp.agent.commands.CreateToken_result;
import org.hyperic.hq.bizapp.agent.commands.GetServer_args;
import org.hyperic.hq.bizapp.agent.commands.GetServer_result;
import org.hyperic.hq.bizapp.agent.commands.SetServer_args;
import org.hyperic.hq.bizapp.agent.commands.SetServer_result;
import org.hyperic.hq.bizapp.agent.server.SSLConnectionListener;
import org.hyperic.hq.bizapp.client.common.CommonServerInteractor;
import org.hyperic.util.security.KeystoreConfig;
import org.hyperic.util.security.KeystoreManager;
import org.hyperic.util.security.SecurityUtil;

public class CommandsServer
implements AgentServerHandler,
TokenStorer,
AgentNotificationHandler {
    private static final long TOKEN_TIMEOUT = 20000L;
    private final CommandsAPIInfo verAPI = new CommandsAPIInfo();
    private final Log log = LogFactory.getLog(CommandsServer.class);
    private TokenManager tokenManager = null;
    private AgentStorageProvider storage = null;
    private AgentDaemon agent = null;
    private final Socket startupSock = null;
    private String tokenFile;
    private String keyAlg = null;
    private AgentStartupCallback agentStartupCallback = null;

    public AgentAPIInfo getAPIInfo() {
        return this.verAPI;
    }

    public String[] getCommandSet() {
        return CommandsAPIInfo.commandSet;
    }

    public AgentRemoteValue dispatchCommand(String cmd, AgentRemoteValue args, InputStream in, OutputStream out) throws AgentRemoteException {
        if (cmd.equals("bizapp:notify")) {
            return this.handleKeystoreChangeNotification();
        }
        if (cmd.equals("bizapp:createToken")) {
            return this.createToken(new CreateToken_args(args));
        }
        if (cmd.equals("bizapp:getCAMServer")) {
            return this.getServer(new GetServer_args(args));
        }
        if (cmd.equals("bizapp:setCAMServer")) {
            return this.setServer(new SetServer_args(args));
        }
        throw new AgentRemoteException("Unknown command: " + cmd);
    }

    private AgentRemoteValue handleKeystoreChangeNotification() {
        this.log.info((Object)"Agent was notified by setup of a keystore change. Applying.");
        CommonServerInteractor.INSTANCE.onKeystoreChange(new AgentKeystoreConfig(this.agent.getBootConfig()));
        return null;
    }

    private String getTokenFile() {
        return this.tokenFile;
    }

    public OutputStream getTokenStoreStream() throws IOException {
        return new FileOutputStream(this.getTokenFile());
    }

    private void storeTokens() throws IOException {
        try {
            this.tokenManager.store();
        }
        catch (IOException exc) {
            this.log.error((Object)("Failed to store token data to '" + this.getTokenFile() + "': " + exc.getMessage()));
            throw exc;
        }
    }

    private CreateToken_result createToken(CreateToken_args args) {
        TokenData newToken = new TokenData(SecurityUtil.generateRandomToken(), System.currentTimeMillis(), false);
        CreateToken_result res = new CreateToken_result();
        res.setToken(newToken.getToken());
        this.tokenManager.addToken(newToken);
        try {
            this.storeTokens();
        }
        catch (IOException exc) {
            // empty catch block
        }
        return res;
    }

    private SetServer_result setServer(SetServer_args args) {
        ProviderInfo provider = args.getProvider();
        String providerMsg = "Setting the server to: " + provider.getProviderAddress();
        providerMsg = providerMsg + "; unidirectional= true";
        this.log.info((Object)providerMsg);
        CommandsAPIInfo.setProvider((AgentStorageProvider)this.storage, (ProviderInfo)provider);
        try {
            this.storage.flush();
        }
        catch (AgentStorageException exc) {
            this.log.error((Object)"Error flushing storage", (Throwable)exc);
        }
        SetServer_result res = new SetServer_result();
        this.agent.sendNotification(CommandsAPIInfo.NOTIFY_SERVER_SET, provider.getProviderAddress());
        return res;
    }

    private GetServer_result getServer(GetServer_args args) {
        GetServer_result res = new GetServer_result();
        res.setProvider(CommandsAPIInfo.getProvider((AgentStorageProvider)this.storage));
        return res;
    }

    private KeyStore getKeyStoreInstance() throws AgentStartException {
        String KEYSTORE_TYPE = "JKS";
        try {
            return KeyStore.getInstance("JKS");
        }
        catch (KeyStoreException exc) {
            throw new AgentStartException("Unable to get keystore instance for JKS", (Exception)exc);
        }
    }

    private KeyManager[] getKeyManagers(KeyStore useStore, char[] filePass) throws AgentStartException {
        KeyManagerFactory res;
        String alg = KeyManagerFactory.getDefaultAlgorithm();
        try {
            res = KeyManagerFactory.getInstance(alg);
            res.init(useStore, filePass);
        }
        catch (Exception exc) {
            throw new AgentStartException("Unable to get default key manager: " + exc.getMessage(), exc);
        }
        return res.getKeyManagers();
    }

    private TokenData generateLocalToken(AgentConfig cfg) throws AgentStartException {
        return new TokenData(SecurityUtil.generateRandomToken(), System.currentTimeMillis(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupTokenManager(AgentConfig cfg) throws AgentStartException {
        String tokenFile = this.getTokenFile();
        this.tokenManager = new TokenManager(20000L, (TokenStorer)this);
        FileInputStream is = null;
        try {
            is = new FileInputStream(tokenFile);
            this.tokenManager.load((InputStream)is);
        }
        catch (IOException exc) {
            this.log.warn((Object)("Unable to load " + tokenFile + ": generating " + "new file: " + exc.getMessage()));
            this.tokenManager.addToken(this.generateLocalToken(cfg));
            try {
                this.storeTokens();
            }
            catch (IOException eExc) {
                String msg = "Unable to store " + tokenFile + ": " + eExc.getMessage();
                throw new AgentStartException(msg);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void handleNotification(String msgClass, String msg) {
        this.log.debug((Object)("handling notification: " + msgClass + ":" + msg));
        if (this.agentStartupCallback != null) {
            this.log.debug((Object)"calling back to agent");
            if (msgClass.equals(AgentDaemon.NOTIFY_AGENT_UP)) {
                this.agentStartupCallback.onAgentStartup(true);
            } else if (msgClass.equals(AgentDaemon.NOTIFY_AGENT_FAILED_START)) {
                this.agentStartupCallback.onAgentStartup(false);
            }
        }
    }

    public void startup(AgentDaemon agent) throws AgentStartException {
        try {
            this.agentStartupCallback = new AgentStartupCallback(agent.getBootConfig());
            agent.registerNotifyHandler((AgentNotificationHandler)this, AgentDaemon.NOTIFY_AGENT_UP);
            agent.registerNotifyHandler((AgentNotificationHandler)this, AgentDaemon.NOTIFY_AGENT_FAILED_START);
        }
        catch (AgentConfigException e) {
            this.log.warn((Object)("Failure to find startup reporting port in sys properties: " + (Object)((Object)e)));
            this.log.debug((Object)e, (Throwable)e);
        }
        catch (IOException e) {
            throw new AgentStartException("Wrapped Exception", (Exception)e);
        }
        this.agent = agent;
        try {
            AgentConfig cfg = agent.getBootConfig();
            this.tokenFile = cfg.getTokenFile();
            this.setupTokenManager(cfg);
            Properties bootConfig = cfg.getBootProperties();
            this.storage = agent.getStorageProvider();
            this.keyAlg = bootConfig.getProperty("agent.keyalg", "RSA");
            AgentKeystoreConfig keystoreConfig = new AgentKeystoreConfig(cfg);
            KeyStore keystore = KeystoreManager.getKeystoreManager().getKeyStore((KeystoreConfig)keystoreConfig);
            KeyManager[] keyManagers = this.getKeyManagers(keystore, keystoreConfig.getFilePassword());
            SSLConnectionListener listener = new SSLConnectionListener(cfg, this.tokenManager);
            agent.setConnectionListener((AgentConnectionListener)listener);
        }
        catch (Exception exc) {
            throw new AgentStartException("Unable to initialize SSL: " + exc.getMessage(), exc);
        }
        this.log.info((Object)"Commands Server started up");
    }

    public final void postInitActions() throws AgentStartException {
    }

    public void shutdown() {
        this.log.info((Object)"Commands Server shut down");
    }

    public void refreshOnPluginsChange() {
        this.log.info((Object)"Agent commands refreshOnPluginsChange");
    }
}

