/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentAssertionException;
import org.hyperic.hq.agent.AgentConfigException;
import org.hyperic.util.PropertyEncryptionUtil;
import org.hyperic.util.PropertyUtil;
import org.hyperic.util.PropertyUtilException;
import org.hyperic.util.file.FileUtil;
import org.hyperic.util.security.SecurityUtil;

public class AgentConfig {
    protected static final Log logger = LogFactory.getLog((String)AgentConfig.class.getName());
    private static final AtomicReference<Properties> defaultProps = new AtomicReference();
    private static final String DEV_URANDOM = "/dev/urandom";
    public static final String WORK_DIR = "work";
    public static final String JSW_PROP_AGENT_BUNDLE = "set.HQ_AGENT_BUNDLE";
    public static final String JSW_PROP_AGENT_ROLLBACK_BUNDLE = "set.HQ_AGENT_ROLLBACK_BUNDLE";
    public static final String JSW_PROP_AGENT_JAVA_HOME = "set.HQ_JAVA_HOME";
    public static final String PROP_LATHER_PROXYHOST = "lather.proxyHost";
    public static final String PROP_LATHER_PROXYPORT = "lather.proxyPort";
    private static final String DEFAULT_PROXY_HOST = "";
    private static final int DEFAULT_PROXY_PORT = -1;
    private static final int DEFAULT_NOTIFY_UP_PORT = -1;
    private static final String DEFAULT_ENBALED_CIPHERS = "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA,TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA,TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA,TLS_ECDH_RSA_WITH_AES_256_CBC_SHA,TLS_DHE_RSA_WITH_AES_256_CBC_SHA,TLS_DHE_DSS_WITH_AES_256_CBC_SHA,TLS_DH_RSA_WITH_AES_256_CBC_SHA,TLS_DH_DSS_WITH_AES_256_CBC_SHA,TLS_RSA_WITH_AES_256_CBC_SHA,TLS_DHE_RSA_WITH_AES_128_CBC_SHA,TLS_RSA_WITH_AES_128_CBC_SHA,TLS_DHE_DSS_WITH_AES_128_CBC_SHA,TLS_DH_RSA_WITH_AES_128_CBC_SHA,TLS_DH_DSS_WITH_AES_128_CBC_SHA";
    private static final String ADDITIONAL_IBM_DEFAULT_ENABLED_CIPHERS = "SSL_RSA_WITH_AES_128_CBC_SHA,SSL_RSA_WITH_AES_256_CBC_SHA";
    public static final String PDK_DIR_KEY = "agent.pdkDir";
    public static final String PDK_LIB_DIR_KEY = "agent.pdkLibDir";
    public static final String PDK_PLUGIN_DIR_KEY = "agent.pdkPluginDir";
    public static final String PDK_WORK_DIR_KEY = "agent.pdkWorkDir";
    public static final String AGENT_BUNDLE_HOME = "agent.bundle.home";
    public static final String SSL_KEYSTORE_ALIAS = "agent.keystore.alias";
    public static final String DEFAULT_SSL_KEYSTORE_ALIAS = "hq";
    public static final String SSL_CLIENT_CERTIFICATE_ALIAS = "agent.keystore.client.certificate.alias";
    public static final String DEFAULT_SSL_CLIENT_CERTIFICATE_ALIAS = "agent";
    public static final String SSL_SERVER_CERTIFICATE_ALIAS = "agent.keystore.server.certificate.alias";
    public static final String DEFAULT_SSL_SERVER_CERTIFICATE_ALIAS = "epops_server";
    public static final String SSL_KEYSTORE_PATH = "agent.keystore.path";
    public static final String SSL_KEYSTORE_PASSWORD = "agent.keystore.password";
    public static final String SSL_KEYSTORE_ACCEPT_UNVERIFIED_CERT = "accept.unverified.certificates";
    public static final String DEFAULT_AGENT_KEY_FILE_NAME = "propEncKey";
    public static final String[] PROP_LISTENPORT;
    public static final String[] PROP_STORAGEPROVIDER;
    public static final String[] PROP_STORAGEPROVIDERINFO;
    public static final String[] PROP_INSTALLHOME;
    public static final String[] PROP_BUNDLEHOME;
    public static final String[] PROP_TMPDIR;
    public static final String[] PROP_LOGDIR;
    public static final String[] PROP_DATADIR;
    public static final String[] PROP_CONFDIR;
    public static final String[] PROP_KEYSTORE_ACCEPT_UNVERIFIED_CERT;
    public static final String[] PROP_KEYSTORE_PATH;
    public static final String AUTO_GENERATED_KEYSTORE_MARKER = "AUTO_GENERATED";
    public static final String[] PROP_KEYSTORE_PASSWORD;
    public static final String[] PROP_LIB_HANDLERS;
    public static final String[] PROP_LIB_HANDLERS_LIB;
    public static final String[] PROP_PDK_DIR;
    public static final String[] PROP_PDK_LIB_DIR;
    public static final String[] PROP_SSL_KEYSTORE_ALIAS;
    public static final String[] PROP_SSL_CLIENT_CERTIFICATE_ALIAS;
    public static final String[] PROP_SSL_SERVER_CERTIFICATE_ALIAS;
    public static final String[] PROP_PDK_PLUGIN_DIR;
    public static final String[] PROP_PDK_WORK_DIR;
    public static final String[] PROP_PROXYHOST;
    public static final String[] PROP_PROXYPORT;
    public static final String DEFAULT_AGENT_PROP_ENC_KEY_FILE_NAME = "agent.scu";
    public static final String[] PROP_ENC_KEY_FILE;
    public static final String PERSISTED_CONTROL_RESPONSES_DIR;
    public static final String[] PROP_ROLLBACK_AGENT_BUNDLE_UPGRADE;
    public static final String[] PROP_ENABLED_CIPHERS;
    public static final Boolean CLOSE_HTTP_CONNECTION_BY_DEFAULT;
    public static final String[] PROP_CLOSE_HTTP_CONNECTION_BY_DEFAULT;
    public static final Integer MAX_HTTP_REQUESTS_PER_CONNECTION;
    public static final String[] PROP_MAX_HTTP_REQUESTS_PER_CONNECTION;
    public static final Boolean SUPPORT_RRDNS;
    public static final String[] PROP_SUPPORT_RRDNS;
    public static final Integer COMMUNICATION_FAIL_PERIOD_IN_MINUTES;
    public static final String[] PROP_COMMUNICATION_FAIL_PERIOD_IN_MINUTES;
    public static final Integer COMMUNICATION_DOWN_PERIOD_IN_MINUTES;
    public static final String[] PROP_COMMUNICATION_DOWN_PERIOD_IN_MINUTES;
    public static final Integer MAX_HTTP_CONNECTION_PER_ROUTE;
    public static final String[] PROP_MAX_HTTP_CONNECTION_PER_ROUTE;
    public static final String PROP_PROPFILE = "agent.propFile";
    public static final String DEFAULT_AGENT_PROPFILE_NAME = "agent.properties";
    public static final String AGENT_CONF_DIR;
    public static final String DEFAULT_PROPFILE;
    public static final String ROLLBACK_PROPFILE = "agent.rollbackPropFile";
    public static final String DEFAULT_ROLLBACKPROPFILE;
    public static final Set<String> ENCRYPTED_PROP_KEYS;
    private static final String QPROP_PRE = "agent.setup.";
    public static final String QPROP_IPADDR = "agent.setup.serverIP";
    public static final String QPROP_SSLPORT = "agent.setup.serverSSLPort";
    public static final String QPROP_LOGIN = "agent.setup.serverLogin";
    public static final String QPROP_PWORD = "agent.setup.serverPword";
    public static final String QPROP_TOKEN_FILE_LINUX = "agent.setup.tokenFileLinux";
    public static final String QPROP_TOKEN_FILE_WINDOWS = "agent.setup.tokenFileWindows";
    public static final String QPROP_LOCAL_IPADDR = "agent.setup.agentIP";
    public static final String QPROP_UNI_POLLING_FREQUENCY = "agent.setup.uniPollingFrequency";
    public static final int DEFAULT_POLLING_FREQUENCY_IN_MS = 60000;
    private static final String[][] propertyList;
    private int listenPort;
    private static final String LOOPBACK_IP = "localhost";
    private int proxyPort = -1;
    private String proxyIp = "";
    private int notifyUpPort = -1;
    private String storageProvider;
    private String storageProviderInfo;
    private Properties bootProps;
    private String tokenFile;
    private String[] enabledCiphers = AgentConfig.getDefaultCiphers().split(",");
    private File logdir;
    private static final Map<String, Properties> propertiesCache;

    private AgentConfig() {
    }

    private static String getDefaultCiphers() {
        if ("IBM Corporation".equals(System.getProperty("java.vm.vendor"))) {
            return "SSL_RSA_WITH_AES_128_CBC_SHA,SSL_RSA_WITH_AES_256_CBC_SHA,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA,TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA,TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA,TLS_ECDH_RSA_WITH_AES_256_CBC_SHA,TLS_DHE_RSA_WITH_AES_256_CBC_SHA,TLS_DHE_DSS_WITH_AES_256_CBC_SHA,TLS_DH_RSA_WITH_AES_256_CBC_SHA,TLS_DH_DSS_WITH_AES_256_CBC_SHA,TLS_RSA_WITH_AES_256_CBC_SHA,TLS_DHE_RSA_WITH_AES_128_CBC_SHA,TLS_RSA_WITH_AES_128_CBC_SHA,TLS_DHE_DSS_WITH_AES_128_CBC_SHA,TLS_DH_RSA_WITH_AES_128_CBC_SHA,TLS_DH_DSS_WITH_AES_128_CBC_SHA";
        }
        return DEFAULT_ENBALED_CIPHERS;
    }

    public static AgentConfig newInstance() {
        try {
            AgentConfig.checkAgentBundleHome();
            return AgentConfig.newInstance(AgentConfig.getDefaultProperties());
        }
        catch (AgentConfigException exc) {
            throw new AgentAssertionException("Default properties should always be proper");
        }
    }

    private static void checkAgentBundleHome() throws AgentConfigException {
        String bundleHome = System.getProperty(PROP_BUNDLEHOME[0]);
        if (bundleHome == null) {
            throw new AgentConfigException("You must provide a value for the system property " + PROP_BUNDLEHOME[0] + ".");
        }
        File bundleHomeDir = new File(bundleHome);
        if (!bundleHomeDir.isDirectory()) {
            throw new AgentConfigException("Invalid value " + PROP_BUNDLEHOME[1] + " for this required system property " + PROP_BUNDLEHOME[0] + ".");
        }
    }

    public static void ensurePropertiesEncryption(String propertiesFileName) throws AgentConfigException {
        Properties props = AgentConfig.getDefaultProperties();
        try {
            PropertyEncryptionUtil.ensurePropertiesEncryption((String)propertiesFileName, (String)props.getProperty(PROP_ENC_KEY_FILE[0]), ENCRYPTED_PROP_KEYS);
        }
        catch (PropertyUtilException exc) {
            throw new AgentConfigException(exc.getMessage(), (Exception)((Object)exc));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean loadProps(Properties props, File propFile) throws AgentConfigException {
        boolean propKeys22;
        Properties tmpProps;
        try {
            tmpProps = PropertyUtil.loadProperties((String)propFile.getPath());
        }
        catch (PropertyUtilException exc) {
            throw new AgentConfigException(exc.getMessage(), (Exception)((Object)exc));
        }
        if (!propFile.exists()) {
            logger.error((Object)(propFile + " does not exist"));
            return false;
        }
        if (!propFile.canRead()) {
            logger.error((Object)("can't read " + propFile));
            return false;
        }
        char[] propEncKey = null;
        try {
            propEncKey = PropertyEncryptionUtil.getPropertyEncryptionKey((String)tmpProps.getProperty(PROP_ENC_KEY_FILE[0], PROP_ENC_KEY_FILE[1]));
            Enumeration<?> propKeys22 = tmpProps.propertyNames();
            while (propKeys22.hasMoreElements()) {
                String key = (String)propKeys22.nextElement();
                String value = tmpProps.getProperty(key);
                if (value != null) {
                    if (SecurityUtil.isMarkedEncrypted((String)value)) {
                        value = SecurityUtil.decrypt((char[])propEncKey, (String)value);
                    }
                    value = value.trim();
                }
                props.put(key, value);
            }
            propKeys22 = true;
        }
        catch (Exception e) {
            boolean bl;
            try {
                logger.error((Object)("Unknown error while loading props: " + e));
                bl = false;
            }
            catch (Throwable throwable) {
                SecurityUtil.clearSensitiveData(propEncKey);
                throw throwable;
            }
            SecurityUtil.clearSensitiveData((char[])propEncKey);
            return bl;
        }
        SecurityUtil.clearSensitiveData((char[])propEncKey);
        return propKeys22;
    }

    public static File getPropertyFile(String propsFile) {
        return new File(propsFile);
    }

    public static Properties getProperties(String propsFile) throws AgentConfigException {
        Properties cachedProperties = propertiesCache.get(propsFile);
        if (cachedProperties != null) {
            return cachedProperties;
        }
        return AgentConfig.getUncachedProperties(propsFile);
    }

    private static Properties getUncachedProperties(String propsFile) throws AgentConfigException {
        Properties useProps = new Properties();
        useProps.putAll((Map<?, ?>)AgentConfig.getDefaultProperties());
        File propFile = AgentConfig.getPropertyFile(propsFile);
        if (!AgentConfig.loadProps(useProps, propFile)) {
            throw new AgentConfigException("Failed to load: " + propFile.getAbsolutePath());
        }
        PropertyUtil.expandVariables((Map)useProps);
        propertiesCache.put(propsFile, useProps);
        return useProps;
    }

    public static AgentConfig newInstance(String propsFile) throws IOException, AgentConfigException {
        return AgentConfig.newInstance(propsFile, false);
    }

    public static AgentConfig newInstance(String propsFile, boolean setDefaultProps) throws IOException, AgentConfigException {
        AgentConfig.checkAgentBundleHome();
        Properties useProps = AgentConfig.getProperties(propsFile);
        return AgentConfig.newInstance(useProps, setDefaultProps);
    }

    public static AgentConfig newInstance(Properties props) throws AgentConfigException {
        return AgentConfig.newInstance(props, false);
    }

    public static AgentConfig newInstance(Properties props, boolean setDefaultProps) throws AgentConfigException {
        if (setDefaultProps) {
            AgentConfig.setDefaultProps(props);
        }
        AgentConfig res = new AgentConfig();
        res.useProperties(props);
        return res;
    }

    public static void setDefaultProps(String propsFile) throws AgentConfigException {
        FileInputStream fis = null;
        Reader propsFileReader = null;
        try {
            Properties props = new Properties();
            fis = new FileInputStream(propsFile);
            propsFileReader = new InputStreamReader((InputStream)fis, "UTF-8");
            props.load(propsFileReader);
            AgentConfig.setDefaultProps(props);
        }
        catch (FileNotFoundException e) {
            throw new AgentConfigException(e);
        }
        catch (IOException e) {
            throw new AgentConfigException(e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (propsFileReader != null) {
                    propsFileReader.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private static void setDefaultProps(Properties props) {
        Properties p = new Properties();
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            p.setProperty(e.getKey().toString(), e.getValue().toString());
        }
        defaultProps.set(p);
    }

    public static Properties getDefaultProperties() {
        Properties rtn = new Properties();
        if (defaultProps.get() != null) {
            for (Map.Entry<Object, Object> e : defaultProps.get().entrySet()) {
                if (e.getValue() == null) continue;
                rtn.setProperty(e.getKey().toString(), e.getValue().toString());
            }
        }
        for (String[] element : propertyList) {
            if (element[1] == null || rtn.containsKey(element[0])) continue;
            rtn.setProperty(element[0], element[1]);
        }
        return rtn;
    }

    public void useProperties(Properties appProps) throws AgentConfigException {
        boolean succeeded;
        this.bootProps = appProps;
        String listenPort = appProps.getProperty(PROP_LISTENPORT[0], PROP_LISTENPORT[1]);
        try {
            this.setListenPort(Integer.parseInt(listenPort));
        }
        catch (NumberFormatException exc) {
            throw new AgentConfigException(PROP_LISTENPORT[0] + " is not an integer");
        }
        String proxyPort = appProps.getProperty(PROP_PROXYPORT[0], PROP_PROXYPORT[1]);
        try {
            int proxyPortInt = Integer.parseInt(proxyPort);
            if (proxyPortInt != -1) {
                this.setProxyPort(proxyPortInt);
            }
        }
        catch (NumberFormatException exc) {
            throw new AgentConfigException(PROP_PROXYPORT[0] + " is not an integer");
        }
        String proxyIp = appProps.getProperty(PROP_PROXYHOST[0], PROP_PROXYPORT[1]);
        this.setProxyIp(proxyIp);
        String[] enabledCiphers = appProps.getProperty(PROP_ENABLED_CIPHERS[0], PROP_ENABLED_CIPHERS[1]).split(",");
        this.setEnabledCiphers(enabledCiphers);
        String storageProvider = appProps.getProperty(PROP_STORAGEPROVIDER[0], PROP_STORAGEPROVIDER[1]);
        this.setStorageProvider(storageProvider);
        String storageProviderInfo = appProps.getProperty(PROP_STORAGEPROVIDERINFO[0], PROP_STORAGEPROVIDERINFO[1]);
        this.setStorageProviderInfo(storageProviderInfo);
        String dataDir = appProps.getProperty(PROP_DATADIR[0], PROP_DATADIR[1]);
        File dir = new File(dataDir);
        try {
            succeeded = FileUtil.makeDirs((File)dir, (int)3);
        }
        catch (InterruptedException e) {
            throw new AgentConfigException("Creation of the data directory was interrupted.");
        }
        if (!succeeded) {
            String parent = new File(dir.getAbsolutePath()).getParentFile().getAbsolutePath();
            throw new AgentConfigException("Error creating the data directory: " + dir.getAbsolutePath() + "\nEnsure that the " + parent + " directory is " + "owned by the user '" + System.getProperty("user.name") + "' and is not a read-only directory.");
        }
        this.tokenFile = appProps.getProperty("agent.tokenFile", dataDir + File.separator + "tokendata");
        String logDir = appProps.getProperty(PROP_LOGDIR[0], PROP_LOGDIR[1]);
        this.logdir = new File(logDir);
        try {
            succeeded = FileUtil.makeDirs((File)dir, (int)3);
        }
        catch (InterruptedException e) {
            throw new AgentConfigException("Creation of log directory was interrupted.");
        }
        if (!succeeded) {
            String parent = new File(this.logdir.getAbsolutePath()).getParentFile().getAbsolutePath();
            throw new AgentConfigException("Error creating log directory: " + dir.getAbsolutePath() + "\nMake sure that the " + parent + " directory is " + "owned by user '" + System.getProperty("user.name") + "' and is not a read-only directory.");
        }
    }

    public File getLogDir() {
        return this.logdir;
    }

    public String getConfDirName() {
        return AGENT_CONF_DIR;
    }

    public void setListenPort(int port) throws AgentConfigException {
        this.verifyValidPortRange(port);
        this.listenPort = port;
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public String getListenIp() {
        return LOOPBACK_IP;
    }

    public void setProxyPort(int port) throws AgentConfigException {
        this.verifyValidPortRange(port);
        this.proxyPort = port;
    }

    public boolean isProxyServerSet() {
        return this.getProxyPort() != -1 && !DEFAULT_PROXY_HOST.equals(this.getProxyIp());
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyIp(String ip) {
        this.proxyIp = ip;
    }

    public String getProxyIp() {
        return this.proxyIp;
    }

    public InetAddress getListenIpAsAddr() throws UnknownHostException {
        return InetAddress.getByName(this.getListenIp());
    }

    public int getNotifyUpPort() {
        return this.notifyUpPort;
    }

    public void setNotifyUpPort(int port) throws AgentConfigException {
        this.verifyValidPortRange(port);
        this.notifyUpPort = port;
    }

    public void setStorageProvider(String storageProvider) {
        this.storageProvider = storageProvider;
    }

    public String getStorageProvider() {
        return this.storageProvider;
    }

    public void setStorageProviderInfo(String info) {
        this.storageProviderInfo = info;
    }

    public String getStorageProviderInfo() {
        return this.storageProviderInfo;
    }

    public Properties getBootProperties() {
        return this.bootProps;
    }

    public String getBootProperty(String propertyName) {
        String bootProperty = null;
        if (StringUtils.isNotBlank((String)propertyName)) {
            bootProperty = this.getBootProperties().getProperty(propertyName);
        }
        return bootProperty;
    }

    public String getTokenFile() {
        return this.tokenFile;
    }

    private void verifyValidPortRange(int port) throws AgentConfigException {
        if (port < 1 || port > 65535) {
            throw new AgentConfigException("Invalid port (not in range 1->65535)");
        }
    }

    public String[] getEnabledCiphers() {
        return this.enabledCiphers;
    }

    public List<String> getEnabledCipherList() {
        return new ArrayList<String>(Arrays.asList(this.getEnabledCiphers()));
    }

    public void setEnabledCiphers(String[] enabledCiphers) {
        this.enabledCiphers = enabledCiphers;
    }

    static {
        if (new File(DEV_URANDOM).exists()) {
            System.setProperty("java.security.egd", "file:/dev/urandom");
        }
        PROP_LISTENPORT = new String[]{"agent.listenPort", Integer.toString(2144)};
        PROP_STORAGEPROVIDER = new String[]{"agent.storageProvider", "org.hyperic.hq.agent.server.AgentDListProvider"};
        PROP_STORAGEPROVIDERINFO = new String[]{"agent.storageProvider.info", "${agent.dataDir}|m|1000|20|50"};
        PROP_INSTALLHOME = new String[]{"agent.install.home", System.getProperty("agent.install.home", System.getProperty("user.dir"))};
        PROP_BUNDLEHOME = new String[]{AGENT_BUNDLE_HOME, System.getProperty(AGENT_BUNDLE_HOME)};
        PROP_TMPDIR = new String[]{"agent.tmpDir", System.getProperty("agent.tmpDir", PROP_BUNDLEHOME[1] + "/tmp")};
        PROP_LOGDIR = new String[]{"agent.logDir", System.getProperty("agent.logDir", PROP_INSTALLHOME[1] + "/log")};
        PROP_DATADIR = new String[]{"agent.dataDir", System.getProperty("agent.dataDir", PROP_INSTALLHOME[1] + "/data")};
        PROP_CONFDIR = new String[]{"agent.confDir", System.getProperty("agent.confDir", PROP_INSTALLHOME[1] + "/conf")};
        PROP_KEYSTORE_ACCEPT_UNVERIFIED_CERT = new String[]{SSL_KEYSTORE_ACCEPT_UNVERIFIED_CERT, "true"};
        PROP_KEYSTORE_PATH = new String[]{SSL_KEYSTORE_PATH, PROP_DATADIR[1] + "/keystore"};
        PROP_KEYSTORE_PASSWORD = new String[]{SSL_KEYSTORE_PASSWORD, AUTO_GENERATED_KEYSTORE_MARKER};
        PROP_LIB_HANDLERS = new String[]{"agent.lib.handlers", PROP_BUNDLEHOME[1] + "/lib/handlers"};
        PROP_LIB_HANDLERS_LIB = new String[]{"agent.lib.handlers.lib", PROP_LIB_HANDLERS[1] + "/lib"};
        PROP_PDK_DIR = new String[]{PDK_DIR_KEY, System.getProperty(PDK_DIR_KEY, PROP_BUNDLEHOME[1] + "/pdk")};
        PROP_PDK_LIB_DIR = new String[]{PDK_LIB_DIR_KEY, System.getProperty(PDK_LIB_DIR_KEY, PROP_PDK_DIR[1] + "/lib")};
        PROP_SSL_KEYSTORE_ALIAS = new String[]{SSL_KEYSTORE_ALIAS, System.getProperty(SSL_KEYSTORE_ALIAS, DEFAULT_SSL_KEYSTORE_ALIAS)};
        PROP_SSL_CLIENT_CERTIFICATE_ALIAS = new String[]{SSL_CLIENT_CERTIFICATE_ALIAS, System.getProperty(SSL_CLIENT_CERTIFICATE_ALIAS, DEFAULT_SSL_CLIENT_CERTIFICATE_ALIAS)};
        PROP_SSL_SERVER_CERTIFICATE_ALIAS = new String[]{SSL_SERVER_CERTIFICATE_ALIAS, System.getProperty(SSL_SERVER_CERTIFICATE_ALIAS, DEFAULT_SSL_SERVER_CERTIFICATE_ALIAS)};
        PROP_PDK_PLUGIN_DIR = new String[]{PDK_PLUGIN_DIR_KEY, System.getProperty(PDK_PLUGIN_DIR_KEY, PROP_PDK_DIR[1] + "/plugins")};
        PROP_PDK_WORK_DIR = new String[]{PDK_WORK_DIR_KEY, System.getProperty(PDK_WORK_DIR_KEY, PROP_PDK_DIR[1] + "/" + WORK_DIR)};
        PROP_PROXYHOST = new String[]{"agent.proxyHost", DEFAULT_PROXY_HOST};
        PROP_PROXYPORT = new String[]{"agent.proxyPort", String.valueOf(-1)};
        PROP_ENC_KEY_FILE = new String[]{"agent.encKeyFile", PROP_CONFDIR[1] + File.separator + DEFAULT_AGENT_PROP_ENC_KEY_FILE_NAME};
        PERSISTED_CONTROL_RESPONSES_DIR = PROP_DATADIR[1] + "/control_responses";
        PROP_ROLLBACK_AGENT_BUNDLE_UPGRADE = new String[]{"agent.rollbackAgentBundleUpgrade", DEFAULT_PROXY_HOST};
        PROP_ENABLED_CIPHERS = new String[]{"agent.enabledCiphers", AgentConfig.getDefaultCiphers()};
        CLOSE_HTTP_CONNECTION_BY_DEFAULT = true;
        PROP_CLOSE_HTTP_CONNECTION_BY_DEFAULT = new String[]{"agent.http.connection.close.default", CLOSE_HTTP_CONNECTION_BY_DEFAULT.toString()};
        MAX_HTTP_REQUESTS_PER_CONNECTION = 5;
        PROP_MAX_HTTP_REQUESTS_PER_CONNECTION = new String[]{"agent.http.connection.max-requests", MAX_HTTP_REQUESTS_PER_CONNECTION.toString()};
        SUPPORT_RRDNS = true;
        PROP_SUPPORT_RRDNS = new String[]{"agent.communication.support.rrdns", SUPPORT_RRDNS.toString()};
        COMMUNICATION_FAIL_PERIOD_IN_MINUTES = 5;
        PROP_COMMUNICATION_FAIL_PERIOD_IN_MINUTES = new String[]{"agent.communication.fail.period.minutes", COMMUNICATION_FAIL_PERIOD_IN_MINUTES.toString()};
        COMMUNICATION_DOWN_PERIOD_IN_MINUTES = 10;
        PROP_COMMUNICATION_DOWN_PERIOD_IN_MINUTES = new String[]{"agent.communication.down.period.interval.minutes", COMMUNICATION_DOWN_PERIOD_IN_MINUTES.toString()};
        MAX_HTTP_CONNECTION_PER_ROUTE = 1;
        PROP_MAX_HTTP_CONNECTION_PER_ROUTE = new String[]{"agent.http.connection.max-connections", MAX_HTTP_CONNECTION_PER_ROUTE.toString()};
        AGENT_CONF_DIR = PROP_CONFDIR[1];
        DEFAULT_PROPFILE = AGENT_CONF_DIR + "/" + DEFAULT_AGENT_PROPFILE_NAME;
        DEFAULT_ROLLBACKPROPFILE = AGENT_CONF_DIR + "/" + "rollback.properties";
        ENCRYPTED_PROP_KEYS = new HashSet<String>();
        ENCRYPTED_PROP_KEYS.add(QPROP_PWORD);
        ENCRYPTED_PROP_KEYS.add(SSL_KEYSTORE_PASSWORD);
        propertyList = new String[][]{PROP_SSL_KEYSTORE_ALIAS, PROP_SSL_CLIENT_CERTIFICATE_ALIAS, PROP_SSL_SERVER_CERTIFICATE_ALIAS, PROP_KEYSTORE_PATH, PROP_KEYSTORE_PASSWORD, PROP_LISTENPORT, PROP_PROXYHOST, PROP_PROXYPORT, PROP_STORAGEPROVIDER, PROP_STORAGEPROVIDERINFO, PROP_INSTALLHOME, PROP_BUNDLEHOME, PROP_TMPDIR, PROP_LOGDIR, PROP_DATADIR, PROP_KEYSTORE_ACCEPT_UNVERIFIED_CERT, PROP_KEYSTORE_PATH, PROP_KEYSTORE_PASSWORD, PROP_LIB_HANDLERS, PROP_LIB_HANDLERS_LIB, PROP_PDK_DIR, PROP_PDK_LIB_DIR, PROP_PDK_PLUGIN_DIR, PROP_PDK_WORK_DIR, PROP_ROLLBACK_AGENT_BUNDLE_UPGRADE, PROP_ENABLED_CIPHERS, PROP_ENC_KEY_FILE, PROP_CLOSE_HTTP_CONNECTION_BY_DEFAULT, PROP_MAX_HTTP_REQUESTS_PER_CONNECTION, PROP_MAX_HTTP_CONNECTION_PER_ROUTE, PROP_SUPPORT_RRDNS, PROP_COMMUNICATION_FAIL_PERIOD_IN_MINUTES, PROP_COMMUNICATION_DOWN_PERIOD_IN_MINUTES};
        propertiesCache = new HashMap<String, Properties>();
    }
}

