/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.snmp4j.PDU;
import org.snmp4j.Session;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.event.ResponseListener;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.AbstractSnmpUtility;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.TreeEvent;
import org.snmp4j.util.TreeListener;

public class TreeUtils
extends AbstractSnmpUtility {
    private static final LogAdapter logger = LogFactory.getLogger(TreeUtils.class);
    private int maxRepetitions = 10;
    private boolean ignoreLexicographicOrder;

    public TreeUtils(Session snmpSession, PDUFactory pduFactory) {
        super(snmpSession, pduFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getSubtree(Target target, OID rootOID) {
        InternalTreeListener listener;
        LinkedList l = new LinkedList();
        InternalTreeListener internalTreeListener = listener = new InternalTreeListener(l);
        synchronized (internalTreeListener) {
            this.walk(target, rootOID, rootOID, null, listener);
            try {
                listener.wait();
            }
            catch (InterruptedException ex) {
                logger.warn("Tree retrieval interrupted: " + ex.getMessage());
            }
        }
        return l;
    }

    public void getSubtree(Target target, OID rootOID, Object userObject, TreeListener listener) {
        this.walk(target, rootOID, rootOID, userObject, listener);
    }

    private void walk(Target target, OID rootOID, OID startOID, Object userObject, TreeListener listener) {
        PDU request = this.pduFactory.createPDU(target);
        request.add(new VariableBinding(startOID));
        if (target.getVersion() == 0) {
            request.setType(-95);
        } else if (request.getType() != -95) {
            request.setType(-91);
            request.setMaxRepetitions(this.maxRepetitions);
        }
        TreeRequest treeRequest = new TreeRequest(listener, rootOID, target, userObject, request);
        treeRequest.send();
    }

    public void setMaxRepetitions(int maxRepetitions) {
        this.maxRepetitions = maxRepetitions;
    }

    public void setIgnoreLexicographicOrder(boolean ignoreLexicographicOrder) {
        this.ignoreLexicographicOrder = ignoreLexicographicOrder;
    }

    public int getMaxRepetitions() {
        return this.maxRepetitions;
    }

    public boolean isIgnoreLexicographicOrder() {
        return this.ignoreLexicographicOrder;
    }

    class InternalTreeListener
    implements TreeListener {
        private List collectedEvents;
        private volatile boolean finished = false;

        public InternalTreeListener(List eventList) {
            this.collectedEvents = eventList;
        }

        public synchronized boolean next(TreeEvent event) {
            this.collectedEvents.add(event);
            return true;
        }

        public synchronized void finished(TreeEvent event) {
            this.collectedEvents.add(event);
            this.finished = true;
            this.notify();
        }

        public List getCollectedEvents() {
            return this.collectedEvents;
        }

        public boolean isFinished() {
            return this.finished;
        }
    }

    class TreeRequest
    implements ResponseListener {
        private TreeListener listener;
        private Object userObject;
        private PDU request;
        private OID rootOID;
        private Target target;

        public TreeRequest(TreeListener listener, OID rootOID, Target target, Object userObject, PDU request) {
            this.listener = listener;
            this.userObject = userObject;
            this.request = request;
            this.rootOID = rootOID;
            this.target = target;
        }

        public void send() {
            try {
                TreeUtils.this.session.send(this.request, this.target, null, this);
            }
            catch (IOException iox) {
                this.listener.finished(new TreeEvent((Object)this, this.userObject, iox));
            }
        }

        public void onResponse(ResponseEvent event) {
            TreeUtils.this.session.cancel(event.getRequest(), this);
            PDU respPDU = event.getResponse();
            if (respPDU == null) {
                this.listener.finished(new TreeEvent((Object)this, this.userObject, -1));
            } else if (respPDU.getErrorStatus() != 0) {
                this.listener.finished(new TreeEvent((Object)this, this.userObject, respPDU.getErrorStatus()));
            } else if (respPDU.getType() == -88) {
                this.listener.finished(new TreeEvent((Object)this, this.userObject, respPDU));
            } else {
                ArrayList<VariableBinding> l = new ArrayList<VariableBinding>(respPDU.size());
                OID lastOID = this.request.get(0).getOid();
                boolean finished = false;
                for (int i = 0; !finished && i < respPDU.size(); ++i) {
                    VariableBinding vb = respPDU.get(i);
                    if (vb.getOid() == null || vb.getOid().size() < this.rootOID.size() || this.rootOID.leftMostCompare(this.rootOID.size(), vb.getOid()) != 0) {
                        finished = true;
                        continue;
                    }
                    if (Null.isExceptionSyntax(vb.getVariable().getSyntax())) {
                        finished = true;
                        continue;
                    }
                    if (!TreeUtils.this.ignoreLexicographicOrder && vb.getOid().compareTo(lastOID) <= 0) {
                        this.listener.finished(new TreeEvent((Object)this, this.userObject, -2));
                        finished = true;
                        break;
                    }
                    lastOID = vb.getOid();
                    l.add(vb);
                }
                if (respPDU.size() == 0) {
                    finished = true;
                }
                VariableBinding[] vbs = l.toArray(new VariableBinding[l.size()]);
                if (finished) {
                    this.listener.finished(new TreeEvent((Object)this, this.userObject, vbs));
                } else {
                    if (this.listener.next(new TreeEvent((Object)this, this.userObject, vbs))) {
                        VariableBinding next = (VariableBinding)respPDU.get(respPDU.size() - 1).clone();
                        next.setVariable(new Null());
                        this.request.set(0, next);
                        this.request.setRequestID(new Integer32(0));
                        this.send();
                        return;
                    }
                    finished = true;
                }
            }
        }
    }
}

