/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.runtime;

import com.sun.xml.internal.bind.unmarshaller.InfosetScanner;
import com.sun.xml.internal.bind.v2.runtime.AssociationMap;
import com.sun.xml.internal.bind.v2.runtime.JAXBContextImpl;
import com.sun.xml.internal.bind.v2.runtime.JaxBeanInfo;
import com.sun.xml.internal.bind.v2.runtime.MarshallerImpl;
import com.sun.xml.internal.bind.v2.runtime.Messages;
import com.sun.xml.internal.bind.v2.runtime.output.DOMOutput;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.InterningXmlVisitor;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.SAXConnector;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.UnmarshallerImpl;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.namespace.QName;
import javax.xml.validation.Schema;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class BinderImpl<XmlNode>
extends Binder<XmlNode> {
    private final JAXBContextImpl context;
    private UnmarshallerImpl unmarshaller;
    private MarshallerImpl marshaller;
    private final InfosetScanner<XmlNode> scanner;
    private final AssociationMap<XmlNode> assoc = new AssociationMap();

    BinderImpl(JAXBContextImpl jAXBContextImpl, InfosetScanner<XmlNode> infosetScanner) {
        this.context = jAXBContextImpl;
        this.scanner = infosetScanner;
    }

    private UnmarshallerImpl getUnmarshaller() {
        if (this.unmarshaller == null) {
            this.unmarshaller = new UnmarshallerImpl(this.context, this.assoc);
        }
        return this.unmarshaller;
    }

    private MarshallerImpl getMarshaller() {
        if (this.marshaller == null) {
            this.marshaller = new MarshallerImpl(this.context, this.assoc);
        }
        return this.marshaller;
    }

    @Override
    public void marshal(Object object, XmlNode XmlNode) throws JAXBException {
        if (XmlNode == null || object == null) {
            throw new IllegalArgumentException();
        }
        this.getMarshaller().marshal(object, this.createOutput(XmlNode));
    }

    private DOMOutput createOutput(XmlNode XmlNode) {
        return new DOMOutput((Node)XmlNode, this.assoc);
    }

    @Override
    public Object updateJAXB(XmlNode XmlNode) throws JAXBException {
        return this.associativeUnmarshal(XmlNode, true, null);
    }

    @Override
    public Object unmarshal(XmlNode XmlNode) throws JAXBException {
        return this.associativeUnmarshal(XmlNode, false, null);
    }

    @Override
    public <T> JAXBElement<T> unmarshal(XmlNode XmlNode, Class<T> clazz) throws JAXBException {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        return (JAXBElement)this.associativeUnmarshal(XmlNode, true, clazz);
    }

    @Override
    public void setSchema(Schema schema) {
        this.getMarshaller().setSchema(schema);
        this.getUnmarshaller().setSchema(schema);
    }

    @Override
    public Schema getSchema() {
        return this.getUnmarshaller().getSchema();
    }

    private Object associativeUnmarshal(XmlNode XmlNode, boolean bl, Class clazz) throws JAXBException {
        if (XmlNode == null) {
            throw new IllegalArgumentException();
        }
        JaxBeanInfo jaxBeanInfo = null;
        if (clazz != null) {
            jaxBeanInfo = this.context.getBeanInfo(clazz, true);
        }
        InterningXmlVisitor interningXmlVisitor = new InterningXmlVisitor(this.getUnmarshaller().createUnmarshallerHandler(this.scanner, bl, jaxBeanInfo));
        this.scanner.setContentHandler(new SAXConnector(interningXmlVisitor, this.scanner.getLocator()));
        try {
            this.scanner.scan(XmlNode);
        }
        catch (SAXException sAXException) {
            throw this.unmarshaller.createUnmarshalException(sAXException);
        }
        return interningXmlVisitor.getContext().getResult();
    }

    @Override
    public XmlNode getXMLNode(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        AssociationMap.Entry<XmlNode> entry = this.assoc.byPeer(object);
        if (entry == null) {
            return null;
        }
        return entry.element();
    }

    @Override
    public Object getJAXBNode(XmlNode XmlNode) {
        if (XmlNode == null) {
            throw new IllegalArgumentException();
        }
        AssociationMap.Entry<XmlNode> entry = this.assoc.byElement(XmlNode);
        if (entry == null) {
            return null;
        }
        if (entry.outer() != null) {
            return entry.outer();
        }
        return entry.inner();
    }

    @Override
    public XmlNode updateXML(Object object) throws JAXBException {
        return this.updateXML(object, this.getXMLNode(object));
    }

    @Override
    public XmlNode updateXML(Object jAXBElement, XmlNode XmlNode) throws JAXBException {
        if (jAXBElement == null || XmlNode == null) {
            throw new IllegalArgumentException();
        }
        Element element = (Element)XmlNode;
        Node node = element.getNextSibling();
        Node node2 = element.getParentNode();
        node2.removeChild(element);
        JaxBeanInfo jaxBeanInfo = this.context.getBeanInfo(jAXBElement, true);
        if (!jaxBeanInfo.isElement()) {
            jAXBElement = new JAXBElement<Object>(new QName(element.getNamespaceURI(), element.getLocalName()), jaxBeanInfo.jaxbType, jAXBElement);
        }
        this.getMarshaller().marshal((Object)jAXBElement, node2);
        Node node3 = node2.getLastChild();
        node2.removeChild(node3);
        node2.insertBefore(node3, node);
        return (XmlNode)node3;
    }

    @Override
    public void setEventHandler(ValidationEventHandler validationEventHandler) throws JAXBException {
        this.getUnmarshaller().setEventHandler(validationEventHandler);
        this.getMarshaller().setEventHandler(validationEventHandler);
    }

    @Override
    public ValidationEventHandler getEventHandler() {
        return this.getUnmarshaller().getEventHandler();
    }

    @Override
    public Object getProperty(String string) throws PropertyException {
        if (string == null) {
            throw new IllegalArgumentException(Messages.NULL_PROPERTY_NAME.format(new Object[0]));
        }
        if (this.excludeProperty(string)) {
            throw new PropertyException(string);
        }
        Object object = null;
        PropertyException propertyException = null;
        try {
            object = this.getMarshaller().getProperty(string);
            return object;
        }
        catch (PropertyException propertyException2) {
            propertyException = propertyException2;
            try {
                object = this.getUnmarshaller().getProperty(string);
                return object;
            }
            catch (PropertyException propertyException3) {
                propertyException = propertyException3;
                propertyException.setStackTrace(Thread.currentThread().getStackTrace());
                throw propertyException;
            }
        }
    }

    @Override
    public void setProperty(String string, Object object) throws PropertyException {
        if (string == null) {
            throw new IllegalArgumentException(Messages.NULL_PROPERTY_NAME.format(new Object[0]));
        }
        if (this.excludeProperty(string)) {
            throw new PropertyException(string, object);
        }
        PropertyException propertyException = null;
        try {
            this.getMarshaller().setProperty(string, object);
            return;
        }
        catch (PropertyException propertyException2) {
            propertyException = propertyException2;
            try {
                this.getUnmarshaller().setProperty(string, object);
                return;
            }
            catch (PropertyException propertyException3) {
                propertyException = propertyException3;
                propertyException.setStackTrace(Thread.currentThread().getStackTrace());
                throw propertyException;
            }
        }
    }

    private boolean excludeProperty(String string) {
        return string.equals("com.sun.xml.internal.bind.characterEscapeHandler") || string.equals("com.sun.xml.internal.bind.xmlDeclaration") || string.equals("com.sun.xml.internal.bind.xmlHeaders");
    }
}

