/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.messaging.saaj.util;

import com.sun.xml.internal.messaging.saaj.util.ByteInputStream;
import com.sun.xml.internal.messaging.saaj.util.ByteOutputStream;
import com.sun.xml.internal.messaging.saaj.util.CharReader;
import com.sun.xml.internal.messaging.saaj.util.CharWriter;
import com.sun.xml.internal.messaging.saaj.util.SAAJUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.transform.stream.StreamSource;

public class JAXMStreamSource
extends StreamSource {
    InputStream in;
    Reader reader;
    private static final boolean lazyContentLength = SAAJUtil.getSystemBoolean("saaj.lazy.contentlength");

    public JAXMStreamSource(InputStream inputStream) throws IOException {
        if (lazyContentLength) {
            this.in = inputStream;
        } else if (inputStream instanceof ByteInputStream) {
            this.in = (ByteInputStream)inputStream;
        } else {
            ByteOutputStream byteOutputStream = new ByteOutputStream();
            byteOutputStream.write(inputStream);
            this.in = byteOutputStream.newInputStream();
        }
    }

    public JAXMStreamSource(Reader reader) throws IOException {
        int n;
        if (lazyContentLength) {
            this.reader = reader;
            return;
        }
        CharWriter charWriter = new CharWriter();
        char[] cArray = new char[1024];
        while (-1 != (n = reader.read(cArray))) {
            charWriter.write(cArray, 0, n);
        }
        this.reader = new CharReader(charWriter.getChars(), charWriter.getCount());
    }

    @Override
    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    public Reader getReader() {
        return this.reader;
    }

    public void reset() throws IOException {
        if (this.in != null) {
            this.in.reset();
        }
        if (this.reader != null) {
            this.reader.reset();
        }
    }
}

