/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.message;

import com.oracle.webservices.internal.api.EnvelopeStyle;
import com.oracle.webservices.internal.api.EnvelopeStyleFeature;
import com.oracle.webservices.internal.api.message.MessageContext;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSFeatureList;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Messages;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.Codec;
import com.sun.xml.internal.ws.api.pipe.Codecs;
import com.sun.xml.internal.ws.binding.WebServiceFeatureList;
import com.sun.xml.internal.ws.transport.http.HttpAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.MTOMFeature;

public class MessageContextFactory
extends com.oracle.webservices.internal.api.message.MessageContextFactory {
    private WSFeatureList features;
    private Codec soapCodec;
    private Codec xmlCodec;
    private EnvelopeStyleFeature envelopeStyle;
    private EnvelopeStyle.Style singleSoapStyle;

    public MessageContextFactory(WebServiceFeature[] webServiceFeatureArray) {
        this(new WebServiceFeatureList(webServiceFeatureArray));
    }

    public MessageContextFactory(WSFeatureList wSFeatureList) {
        this.features = wSFeatureList;
        this.envelopeStyle = this.features.get(EnvelopeStyleFeature.class);
        if (this.envelopeStyle == null) {
            this.envelopeStyle = new EnvelopeStyleFeature(EnvelopeStyle.Style.SOAP11);
            this.features.mergeFeatures(new WebServiceFeature[]{this.envelopeStyle}, false);
        }
        for (EnvelopeStyle.Style style : this.envelopeStyle.getStyles()) {
            if (style.isXML()) {
                if (this.xmlCodec != null) continue;
                this.xmlCodec = Codecs.createXMLCodec(this.features);
                continue;
            }
            if (this.soapCodec == null) {
                this.soapCodec = Codecs.createSOAPBindingCodec(this.features);
            }
            this.singleSoapStyle = style;
        }
    }

    @Override
    protected com.oracle.webservices.internal.api.message.MessageContextFactory newFactory(WebServiceFeature ... webServiceFeatureArray) {
        return new MessageContextFactory(webServiceFeatureArray);
    }

    @Override
    public MessageContext createContext() {
        return this.packet(null);
    }

    @Override
    public MessageContext createContext(SOAPMessage sOAPMessage) {
        this.throwIfIllegalMessageArgument(sOAPMessage);
        return this.packet(Messages.create(sOAPMessage));
    }

    @Override
    public MessageContext createContext(Source source, EnvelopeStyle.Style style) {
        this.throwIfIllegalMessageArgument(source);
        return this.packet(Messages.create(source, SOAPVersion.from(style)));
    }

    @Override
    public MessageContext createContext(Source source) {
        this.throwIfIllegalMessageArgument(source);
        return this.packet(Messages.create(source, SOAPVersion.from(this.singleSoapStyle)));
    }

    @Override
    public MessageContext createContext(InputStream inputStream, String string) throws IOException {
        this.throwIfIllegalMessageArgument(inputStream);
        Packet packet = this.packet(null);
        this.soapCodec.decode(inputStream, string, packet);
        return packet;
    }

    @Override
    @Deprecated
    public MessageContext createContext(InputStream inputStream, MimeHeaders mimeHeaders) throws IOException {
        String string = MessageContextFactory.getHeader(mimeHeaders, "Content-Type");
        Packet packet = (Packet)this.createContext(inputStream, string);
        packet.acceptableMimeTypes = MessageContextFactory.getHeader(mimeHeaders, "Accept");
        packet.soapAction = HttpAdapter.fixQuotesAroundSoapAction(MessageContextFactory.getHeader(mimeHeaders, "SOAPAction"));
        return packet;
    }

    static String getHeader(MimeHeaders mimeHeaders, String string) {
        String[] stringArray = mimeHeaders.getHeader(string);
        return stringArray != null && stringArray.length > 0 ? stringArray[0] : null;
    }

    static Map<String, List<String>> toMap(MimeHeaders mimeHeaders) {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        Iterator iterator = mimeHeaders.getAllHeaders();
        while (iterator.hasNext()) {
            MimeHeader mimeHeader = (MimeHeader)iterator.next();
            List<String> list = hashMap.get(mimeHeader.getName());
            if (list == null) {
                list = new ArrayList<String>();
                hashMap.put(mimeHeader.getName(), list);
            }
            list.add(mimeHeader.getValue());
        }
        return hashMap;
    }

    public MessageContext createContext(Message message) {
        this.throwIfIllegalMessageArgument(message);
        return this.packet(message);
    }

    private Packet packet(Message message) {
        MTOMFeature mTOMFeature;
        Packet packet = new Packet();
        packet.codec = this.soapCodec;
        if (message != null) {
            packet.setMessage(message);
        }
        if ((mTOMFeature = this.features.get(MTOMFeature.class)) != null) {
            packet.setMtomFeature(mTOMFeature);
        }
        return packet;
    }

    private void throwIfIllegalMessageArgument(Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException("null messages are not allowed.  Consider using MessageContextFactory.createContext()");
        }
    }

    @Override
    @Deprecated
    public MessageContext doCreate() {
        return this.packet(null);
    }

    @Override
    @Deprecated
    public MessageContext doCreate(SOAPMessage sOAPMessage) {
        return this.createContext(sOAPMessage);
    }

    @Override
    @Deprecated
    public MessageContext doCreate(Source source, SOAPVersion sOAPVersion) {
        return this.packet(Messages.create(source, sOAPVersion));
    }
}

