/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.policy.subject;

import com.sun.istack.internal.logging.Logger;
import com.sun.xml.internal.ws.resources.BindingApiMessages;
import javax.xml.namespace.QName;

public class BindingSubject {
    private static final Logger LOGGER = Logger.getLogger(BindingSubject.class);
    private final QName name;
    private final WsdlMessageType messageType;
    private final WsdlNameScope nameScope;
    private final BindingSubject parent;

    BindingSubject(QName qName, WsdlNameScope wsdlNameScope, BindingSubject bindingSubject) {
        this(qName, WsdlMessageType.NO_MESSAGE, wsdlNameScope, bindingSubject);
    }

    BindingSubject(QName qName, WsdlMessageType wsdlMessageType, WsdlNameScope wsdlNameScope, BindingSubject bindingSubject) {
        this.name = qName;
        this.messageType = wsdlMessageType;
        this.nameScope = wsdlNameScope;
        this.parent = bindingSubject;
    }

    public static BindingSubject createBindingSubject(QName qName) {
        return new BindingSubject(qName, WsdlNameScope.ENDPOINT, null);
    }

    public static BindingSubject createOperationSubject(QName qName, QName qName2) {
        BindingSubject bindingSubject = BindingSubject.createBindingSubject(qName);
        return new BindingSubject(qName2, WsdlNameScope.OPERATION, bindingSubject);
    }

    public static BindingSubject createInputMessageSubject(QName qName, QName qName2, QName qName3) {
        BindingSubject bindingSubject = BindingSubject.createOperationSubject(qName, qName2);
        return new BindingSubject(qName3, WsdlMessageType.INPUT, WsdlNameScope.MESSAGE, bindingSubject);
    }

    public static BindingSubject createOutputMessageSubject(QName qName, QName qName2, QName qName3) {
        BindingSubject bindingSubject = BindingSubject.createOperationSubject(qName, qName2);
        return new BindingSubject(qName3, WsdlMessageType.OUTPUT, WsdlNameScope.MESSAGE, bindingSubject);
    }

    public static BindingSubject createFaultMessageSubject(QName qName, QName qName2, QName qName3) {
        if (qName3 == null) {
            throw LOGGER.logSevereException(new IllegalArgumentException(BindingApiMessages.BINDING_API_NO_FAULT_MESSAGE_NAME()));
        }
        BindingSubject bindingSubject = BindingSubject.createOperationSubject(qName, qName2);
        return new BindingSubject(qName3, WsdlMessageType.FAULT, WsdlNameScope.MESSAGE, bindingSubject);
    }

    public QName getName() {
        return this.name;
    }

    public BindingSubject getParent() {
        return this.parent;
    }

    public boolean isBindingSubject() {
        if (this.nameScope == WsdlNameScope.ENDPOINT) {
            return this.parent == null;
        }
        return false;
    }

    public boolean isOperationSubject() {
        if (this.nameScope == WsdlNameScope.OPERATION && this.parent != null) {
            return this.parent.isBindingSubject();
        }
        return false;
    }

    public boolean isMessageSubject() {
        if (this.nameScope == WsdlNameScope.MESSAGE && this.parent != null) {
            return this.parent.isOperationSubject();
        }
        return false;
    }

    public boolean isInputMessageSubject() {
        return this.isMessageSubject() && this.messageType == WsdlMessageType.INPUT;
    }

    public boolean isOutputMessageSubject() {
        return this.isMessageSubject() && this.messageType == WsdlMessageType.OUTPUT;
    }

    public boolean isFaultMessageSubject() {
        return this.isMessageSubject() && this.messageType == WsdlMessageType.FAULT;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof BindingSubject)) {
            return false;
        }
        BindingSubject bindingSubject = (BindingSubject)object;
        boolean bl = true;
        bl = bl && (this.name == null ? bindingSubject.name == null : this.name.equals(bindingSubject.name));
        bl = bl && this.messageType.equals((Object)bindingSubject.messageType);
        boolean bl2 = bl = bl && this.nameScope.equals((Object)bindingSubject.nameScope);
        bl = bl && (this.parent == null ? bindingSubject.parent == null : this.parent.equals(bindingSubject.parent));
        return bl;
    }

    public int hashCode() {
        int n = 23;
        n = 29 * n + (this.name == null ? 0 : this.name.hashCode());
        n = 29 * n + this.messageType.hashCode();
        n = 29 * n + this.nameScope.hashCode();
        n = 29 * n + (this.parent == null ? 0 : this.parent.hashCode());
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("BindingSubject[");
        stringBuilder.append(this.name).append(", ").append((Object)this.messageType);
        stringBuilder.append(", ").append((Object)this.nameScope).append(", ").append(this.parent);
        return stringBuilder.append("]").toString();
    }

    private static enum WsdlMessageType {
        NO_MESSAGE,
        INPUT,
        OUTPUT,
        FAULT;

    }

    private static enum WsdlNameScope {
        SERVICE,
        ENDPOINT,
        OPERATION,
        MESSAGE;

    }
}

