/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.transport.http;

import com.oracle.webservices.internal.api.message.PropertySet;
import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.Component;
import com.sun.xml.internal.ws.api.EndpointAddress;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.addressing.NonAnonymousResponseProcessor;
import com.sun.xml.internal.ws.api.ha.HaInfo;
import com.sun.xml.internal.ws.api.message.ExceptionHasMessage;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.Codec;
import com.sun.xml.internal.ws.api.server.AbstractServerAsyncTransport;
import com.sun.xml.internal.ws.api.server.Adapter;
import com.sun.xml.internal.ws.api.server.BoundEndpoint;
import com.sun.xml.internal.ws.api.server.DocumentAddressResolver;
import com.sun.xml.internal.ws.api.server.Module;
import com.sun.xml.internal.ws.api.server.PortAddressResolver;
import com.sun.xml.internal.ws.api.server.SDDocument;
import com.sun.xml.internal.ws.api.server.ServiceDefinition;
import com.sun.xml.internal.ws.api.server.TransportBackChannel;
import com.sun.xml.internal.ws.api.server.WSEndpoint;
import com.sun.xml.internal.ws.api.server.WebServiceContextDelegate;
import com.sun.xml.internal.ws.fault.SOAPFaultBuilder;
import com.sun.xml.internal.ws.resources.WsservletMessages;
import com.sun.xml.internal.ws.server.UnsupportedMediaException;
import com.sun.xml.internal.ws.transport.http.HttpAdapterList;
import com.sun.xml.internal.ws.transport.http.HttpMetadataPublisher;
import com.sun.xml.internal.ws.transport.http.WSHTTPConnection;
import com.sun.xml.internal.ws.util.ByteArrayBuffer;
import com.sun.xml.internal.ws.util.Pool;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.http.HTTPBinding;

public class HttpAdapter
extends Adapter<HttpToolkit> {
    private static final Logger LOGGER;
    protected Map<String, SDDocument> wsdls;
    private Map<SDDocument, String> revWsdls;
    private ServiceDefinition serviceDefinition = null;
    public final HttpAdapterList<? extends HttpAdapter> owner;
    public final String urlPattern;
    protected boolean stickyCookie;
    protected boolean disableJreplicaCookie = false;
    public static final CompletionCallback NO_OP_COMPLETION_CALLBACK;
    public static volatile boolean dump;
    public static volatile int dump_threshold;
    public static volatile boolean publishStatusPage;

    public static HttpAdapter createAlone(WSEndpoint wSEndpoint) {
        return new DummyList().createAdapter("", "", wSEndpoint);
    }

    protected HttpAdapter(WSEndpoint wSEndpoint, HttpAdapterList<? extends HttpAdapter> httpAdapterList) {
        this(wSEndpoint, httpAdapterList, null);
    }

    protected HttpAdapter(WSEndpoint wSEndpoint, HttpAdapterList<? extends HttpAdapter> httpAdapterList, String string) {
        super(wSEndpoint);
        this.owner = httpAdapterList;
        this.urlPattern = string;
        this.initWSDLMap(wSEndpoint.getServiceDefinition());
    }

    public ServiceDefinition getServiceDefinition() {
        return this.serviceDefinition;
    }

    public final void initWSDLMap(ServiceDefinition serviceDefinition) {
        this.serviceDefinition = serviceDefinition;
        if (serviceDefinition == null) {
            this.wsdls = Collections.emptyMap();
            this.revWsdls = Collections.emptyMap();
        } else {
            this.wsdls = new HashMap<String, SDDocument>();
            TreeMap<String, SDDocument> treeMap = new TreeMap<String, SDDocument>();
            for (SDDocument sDDocument : serviceDefinition) {
                if (sDDocument == serviceDefinition.getPrimary()) {
                    this.wsdls.put("wsdl", sDDocument);
                    this.wsdls.put("WSDL", sDDocument);
                    continue;
                }
                treeMap.put(sDDocument.getURL().toString(), sDDocument);
            }
            int n = 1;
            int n2 = 1;
            for (Map.Entry entry : treeMap.entrySet()) {
                SDDocument sDDocument = (SDDocument)entry.getValue();
                if (sDDocument.isWSDL()) {
                    this.wsdls.put("wsdl=" + n++, sDDocument);
                }
                if (!sDDocument.isSchema()) continue;
                this.wsdls.put("xsd=" + n2++, sDDocument);
            }
            this.revWsdls = new HashMap<SDDocument, String>();
            for (Map.Entry<Object, Object> entry : this.wsdls.entrySet()) {
                if (((String)entry.getKey()).equals("WSDL")) continue;
                this.revWsdls.put((SDDocument)entry.getValue(), (String)entry.getKey());
            }
        }
    }

    public String getValidPath() {
        if (this.urlPattern.endsWith("/*")) {
            return this.urlPattern.substring(0, this.urlPattern.length() - 2);
        }
        return this.urlPattern;
    }

    @Override
    protected HttpToolkit createToolkit() {
        return new HttpToolkit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(@NotNull WSHTTPConnection wSHTTPConnection) throws IOException {
        if (this.handleGet(wSHTTPConnection)) {
            return;
        }
        Pool pool = this.getPool();
        HttpToolkit httpToolkit = (HttpToolkit)pool.take();
        try {
            httpToolkit.handle(wSHTTPConnection);
        }
        finally {
            pool.recycle(httpToolkit);
        }
    }

    public boolean handleGet(@NotNull WSHTTPConnection wSHTTPConnection) throws IOException {
        if (wSHTTPConnection.getRequestMethod().equals("GET")) {
            for (Component component : this.endpoint.getComponents()) {
                HttpMetadataPublisher httpMetadataPublisher = component.getSPI(HttpMetadataPublisher.class);
                if (httpMetadataPublisher == null || !httpMetadataPublisher.handleMetadataRequest(this, wSHTTPConnection)) continue;
                return true;
            }
            if (this.isMetadataQuery(wSHTTPConnection.getQueryString())) {
                this.publishWSDL(wSHTTPConnection);
                return true;
            }
            WSBinding wSBinding = this.getEndpoint().getBinding();
            if (!(wSBinding instanceof HTTPBinding)) {
                this.writeWebServicesHtmlPage(wSHTTPConnection);
                return true;
            }
        } else if (wSHTTPConnection.getRequestMethod().equals("HEAD")) {
            wSHTTPConnection.getInput().close();
            WSBinding wSBinding = this.getEndpoint().getBinding();
            if (this.isMetadataQuery(wSHTTPConnection.getQueryString())) {
                SDDocument sDDocument = this.wsdls.get(wSHTTPConnection.getQueryString());
                wSHTTPConnection.setStatus(sDDocument != null ? 200 : 404);
                wSHTTPConnection.getOutput().close();
                wSHTTPConnection.close();
                return true;
            }
            if (!(wSBinding instanceof HTTPBinding)) {
                wSHTTPConnection.setStatus(404);
                wSHTTPConnection.getOutput().close();
                wSHTTPConnection.close();
                return true;
            }
        }
        return false;
    }

    private Packet decodePacket(@NotNull WSHTTPConnection wSHTTPConnection, @NotNull Codec codec) throws IOException {
        String string = wSHTTPConnection.getRequestHeader("Content-Type");
        InputStream inputStream = wSHTTPConnection.getInput();
        Packet packet = new Packet();
        packet.soapAction = HttpAdapter.fixQuotesAroundSoapAction(wSHTTPConnection.getRequestHeader("SOAPAction"));
        packet.wasTransportSecure = wSHTTPConnection.isSecure();
        packet.acceptableMimeTypes = wSHTTPConnection.getRequestHeader("Accept");
        packet.addSatellite(wSHTTPConnection);
        this.addSatellites(packet);
        packet.isAdapterDeliversNonAnonymousResponse = true;
        packet.component = this;
        packet.transportBackChannel = new Oneway(wSHTTPConnection);
        packet.webServiceContextDelegate = wSHTTPConnection.getWebServiceContextDelegate();
        packet.setState(Packet.State.ServerRequest);
        if (dump || LOGGER.isLoggable(Level.FINER)) {
            ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
            byteArrayBuffer.write(inputStream);
            inputStream.close();
            HttpAdapter.dump(byteArrayBuffer, "HTTP request", wSHTTPConnection.getRequestHeaders());
            inputStream = byteArrayBuffer.newInputStream();
        }
        codec.decode(inputStream, string, packet);
        return packet;
    }

    protected void addSatellites(Packet packet) {
    }

    public static String fixQuotesAroundSoapAction(String string) {
        if (!(string == null || string.startsWith("\"") && string.endsWith("\""))) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Received WS-I BP non-conformant Unquoted SoapAction HTTP header: {0}", string);
            }
            String string2 = string;
            if (!string.startsWith("\"")) {
                string2 = "\"" + string2;
            }
            if (!string.endsWith("\"")) {
                string2 = string2 + "\"";
            }
            return string2;
        }
        return string;
    }

    protected NonAnonymousResponseProcessor getNonAnonymousResponseProcessor() {
        return NonAnonymousResponseProcessor.getDefault();
    }

    protected void writeClientError(int n, @NotNull OutputStream outputStream, @NotNull Packet packet) throws IOException {
    }

    private boolean isClientErrorStatus(int n) {
        return n == 403;
    }

    private boolean isNonAnonymousUri(EndpointAddress endpointAddress) {
        return endpointAddress != null && !endpointAddress.toString().equals(AddressingVersion.W3C.anonymousUri) && !endpointAddress.toString().equals(AddressingVersion.MEMBER.anonymousUri);
    }

    private void encodePacket(@NotNull Packet packet, @NotNull WSHTTPConnection wSHTTPConnection, @NotNull Codec codec) throws IOException {
        Object object;
        Object object2;
        if (this.isNonAnonymousUri(packet.endpointAddress) && packet.getMessage() != null) {
            try {
                packet = this.getNonAnonymousResponseProcessor().process(packet);
            }
            catch (RuntimeException runtimeException) {
                object2 = packet.getBinding().getSOAPVersion();
                object = SOAPFaultBuilder.createSOAPFaultMessage((SOAPVersion)((Object)object2), null, runtimeException);
                packet = packet.createServerResponse((Message)object, packet.endpoint.getPort(), null, packet.endpoint.getBinding());
            }
        }
        if (wSHTTPConnection.isClosed()) {
            return;
        }
        Message message = packet.getMessage();
        this.addStickyCookie(wSHTTPConnection);
        this.addReplicaCookie(wSHTTPConnection, packet);
        if (message == null) {
            if (!wSHTTPConnection.isClosed()) {
                if (wSHTTPConnection.getStatus() == 0) {
                    wSHTTPConnection.setStatus(202);
                }
                Object object3 = object2 = wSHTTPConnection.getProtocol().contains("1.1") ? wSHTTPConnection.getOutput() : new Http10OutputStream(wSHTTPConnection);
                if (dump || LOGGER.isLoggable(Level.FINER)) {
                    object = new ByteArrayBuffer();
                    codec.encode(packet, (OutputStream)object);
                    HttpAdapter.dump((ByteArrayBuffer)object, "HTTP response " + wSHTTPConnection.getStatus(), wSHTTPConnection.getResponseHeaders());
                    ((ByteArrayBuffer)object).writeTo((OutputStream)object2);
                } else {
                    codec.encode(packet, (OutputStream)object2);
                }
                try {
                    ((OutputStream)object2).close();
                }
                catch (IOException iOException) {
                    throw new WebServiceException(iOException);
                }
            }
        } else {
            if (wSHTTPConnection.getStatus() == 0) {
                wSHTTPConnection.setStatus(message.isFault() ? 500 : 200);
            }
            if (this.isClientErrorStatus(wSHTTPConnection.getStatus())) {
                object2 = wSHTTPConnection.getOutput();
                if (dump || LOGGER.isLoggable(Level.FINER)) {
                    object = new ByteArrayBuffer();
                    this.writeClientError(wSHTTPConnection.getStatus(), (OutputStream)object, packet);
                    HttpAdapter.dump((ByteArrayBuffer)object, "HTTP response " + wSHTTPConnection.getStatus(), wSHTTPConnection.getResponseHeaders());
                    ((ByteArrayBuffer)object).writeTo((OutputStream)object2);
                } else {
                    this.writeClientError(wSHTTPConnection.getStatus(), (OutputStream)object2, packet);
                }
                ((OutputStream)object2).close();
                return;
            }
            object2 = codec.getStaticContentType(packet);
            if (object2 != null) {
                wSHTTPConnection.setContentTypeResponseHeader(object2.getContentType());
                Object object4 = object = wSHTTPConnection.getProtocol().contains("1.1") ? wSHTTPConnection.getOutput() : new Http10OutputStream(wSHTTPConnection);
                if (dump || LOGGER.isLoggable(Level.FINER)) {
                    ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
                    codec.encode(packet, byteArrayBuffer);
                    HttpAdapter.dump(byteArrayBuffer, "HTTP response " + wSHTTPConnection.getStatus(), wSHTTPConnection.getResponseHeaders());
                    byteArrayBuffer.writeTo((OutputStream)object);
                } else {
                    codec.encode(packet, (OutputStream)object);
                }
                ((OutputStream)object).close();
            } else {
                object = new ByteArrayBuffer();
                object2 = codec.encode(packet, (OutputStream)object);
                wSHTTPConnection.setContentTypeResponseHeader(object2.getContentType());
                if (dump || LOGGER.isLoggable(Level.FINER)) {
                    HttpAdapter.dump((ByteArrayBuffer)object, "HTTP response " + wSHTTPConnection.getStatus(), wSHTTPConnection.getResponseHeaders());
                }
                OutputStream outputStream = wSHTTPConnection.getOutput();
                ((ByteArrayBuffer)object).writeTo(outputStream);
                outputStream.close();
            }
        }
    }

    private void addStickyCookie(WSHTTPConnection wSHTTPConnection) {
        if (this.stickyCookie) {
            String string = wSHTTPConnection.getRequestHeader("proxy-jroute");
            if (string == null) {
                return;
            }
            String string2 = wSHTTPConnection.getCookie("JROUTE");
            if (string2 == null || !string2.equals(string)) {
                wSHTTPConnection.setCookie("JROUTE", string);
            }
        }
    }

    private void addReplicaCookie(WSHTTPConnection wSHTTPConnection, Packet packet) {
        if (this.stickyCookie) {
            HaInfo haInfo = null;
            if (packet.supports("com.sun.xml.internal.ws.api.message.packet.hainfo")) {
                haInfo = (HaInfo)packet.get("com.sun.xml.internal.ws.api.message.packet.hainfo");
            }
            if (haInfo != null) {
                wSHTTPConnection.setCookie("METRO_KEY", haInfo.getKey());
                if (!this.disableJreplicaCookie) {
                    wSHTTPConnection.setCookie("JREPLICA", haInfo.getReplicaInstance());
                }
            }
        }
    }

    public void invokeAsync(WSHTTPConnection wSHTTPConnection) throws IOException {
        this.invokeAsync(wSHTTPConnection, NO_OP_COMPLETION_CALLBACK);
    }

    public void invokeAsync(final WSHTTPConnection wSHTTPConnection, final CompletionCallback completionCallback) throws IOException {
        Packet packet;
        if (this.handleGet(wSHTTPConnection)) {
            completionCallback.onCompletion();
            return;
        }
        final Pool pool = this.getPool();
        final HttpToolkit httpToolkit = (HttpToolkit)pool.take();
        try {
            packet = this.decodePacket(wSHTTPConnection, httpToolkit.codec);
        }
        catch (ExceptionHasMessage exceptionHasMessage) {
            LOGGER.log(Level.SEVERE, exceptionHasMessage.getMessage(), exceptionHasMessage);
            Packet packet2 = new Packet();
            packet2.setMessage(exceptionHasMessage.getFaultMessage());
            this.encodePacket(packet2, wSHTTPConnection, httpToolkit.codec);
            pool.recycle(httpToolkit);
            wSHTTPConnection.close();
            completionCallback.onCompletion();
            return;
        }
        catch (UnsupportedMediaException unsupportedMediaException) {
            LOGGER.log(Level.SEVERE, unsupportedMediaException.getMessage(), unsupportedMediaException);
            Packet packet3 = new Packet();
            wSHTTPConnection.setStatus(415);
            this.encodePacket(packet3, wSHTTPConnection, httpToolkit.codec);
            pool.recycle(httpToolkit);
            wSHTTPConnection.close();
            completionCallback.onCompletion();
            return;
        }
        this.endpoint.process(packet, new WSEndpoint.CompletionCallback(){

            @Override
            public void onCompletion(@NotNull Packet packet) {
                try {
                    try {
                        HttpAdapter.this.encodePacket(packet, wSHTTPConnection, httpToolkit.codec);
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.SEVERE, iOException.getMessage(), iOException);
                    }
                    pool.recycle(httpToolkit);
                }
                finally {
                    wSHTTPConnection.close();
                    completionCallback.onCompletion();
                }
            }
        }, null);
    }

    private boolean isMetadataQuery(String string) {
        return string != null && (string.equals("WSDL") || string.startsWith("wsdl") || string.startsWith("xsd="));
    }

    public void publishWSDL(@NotNull WSHTTPConnection wSHTTPConnection) throws IOException {
        wSHTTPConnection.getInput().close();
        SDDocument sDDocument = this.wsdls.get(wSHTTPConnection.getQueryString());
        if (sDDocument == null) {
            this.writeNotFoundErrorPage(wSHTTPConnection, "Invalid Request");
            return;
        }
        wSHTTPConnection.setStatus(200);
        wSHTTPConnection.setContentTypeResponseHeader("text/xml;charset=utf-8");
        OutputStream outputStream = wSHTTPConnection.getProtocol().contains("1.1") ? wSHTTPConnection.getOutput() : new Http10OutputStream(wSHTTPConnection);
        PortAddressResolver portAddressResolver = this.getPortAddressResolver(wSHTTPConnection.getBaseAddress());
        DocumentAddressResolver documentAddressResolver = this.getDocumentAddressResolver(portAddressResolver);
        sDDocument.writeTo(portAddressResolver, documentAddressResolver, outputStream);
        outputStream.close();
    }

    public PortAddressResolver getPortAddressResolver(String string) {
        return this.owner.createPortAddressResolver(string, this.endpoint.getImplementationClass());
    }

    public DocumentAddressResolver getDocumentAddressResolver(PortAddressResolver portAddressResolver) {
        final String string = portAddressResolver.getAddressFor(this.endpoint.getServiceName(), this.endpoint.getPortName().getLocalPart());
        assert (string != null);
        return new DocumentAddressResolver(){

            @Override
            public String getRelativeAddressFor(@NotNull SDDocument sDDocument, @NotNull SDDocument sDDocument2) {
                assert (HttpAdapter.this.revWsdls.containsKey(sDDocument2));
                return string + '?' + (String)HttpAdapter.this.revWsdls.get(sDDocument2);
            }
        };
    }

    private void writeNotFoundErrorPage(WSHTTPConnection wSHTTPConnection, String string) throws IOException {
        wSHTTPConnection.setStatus(404);
        wSHTTPConnection.setContentTypeResponseHeader("text/html; charset=utf-8");
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(wSHTTPConnection.getOutput(), "UTF-8"));
        printWriter.println("<html>");
        printWriter.println("<head><title>");
        printWriter.println(WsservletMessages.SERVLET_HTML_TITLE());
        printWriter.println("</title></head>");
        printWriter.println("<body>");
        printWriter.println(WsservletMessages.SERVLET_HTML_NOT_FOUND(string));
        printWriter.println("</body>");
        printWriter.println("</html>");
        printWriter.close();
    }

    private void writeInternalServerError(WSHTTPConnection wSHTTPConnection) throws IOException {
        wSHTTPConnection.setStatus(500);
        wSHTTPConnection.getOutput().close();
    }

    private static void dump(ByteArrayBuffer byteArrayBuffer, String string, Map<String, List<String>> map) throws IOException {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream, true);
        printWriter.println("---[" + string + "]---");
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                if (((List)entry.getValue()).isEmpty()) {
                    printWriter.println(entry.getValue());
                    continue;
                }
                for (String string2 : (List)entry.getValue()) {
                    printWriter.println((String)entry.getKey() + ": " + string2);
                }
            }
        }
        if (byteArrayBuffer.size() > dump_threshold) {
            object = byteArrayBuffer.getRawData();
            byteArrayOutputStream.write((byte[])object, 0, dump_threshold);
            printWriter.println();
            printWriter.println(WsservletMessages.MESSAGE_TOO_LONG(HttpAdapter.class.getName() + ".dumpTreshold"));
        } else {
            byteArrayBuffer.writeTo(byteArrayOutputStream);
        }
        printWriter.println("--------------------");
        object = byteArrayOutputStream.toString();
        if (dump) {
            System.out.println((String)object);
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, (String)object);
        }
    }

    private void writeWebServicesHtmlPage(WSHTTPConnection wSHTTPConnection) throws IOException {
        if (!publishStatusPage) {
            return;
        }
        wSHTTPConnection.getInput().close();
        wSHTTPConnection.setStatus(200);
        wSHTTPConnection.setContentTypeResponseHeader("text/html; charset=utf-8");
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(wSHTTPConnection.getOutput(), "UTF-8"));
        printWriter.println("<html>");
        printWriter.println("<head><title>");
        printWriter.println(WsservletMessages.SERVLET_HTML_TITLE());
        printWriter.println("</title></head>");
        printWriter.println("<body>");
        printWriter.println(WsservletMessages.SERVLET_HTML_TITLE_2());
        Module module = this.getEndpoint().getContainer().getSPI(Module.class);
        List<Object> list = Collections.emptyList();
        if (module != null) {
            list = module.getBoundEndpoints();
        }
        if (list.isEmpty()) {
            printWriter.println(WsservletMessages.SERVLET_HTML_NO_INFO_AVAILABLE());
        } else {
            printWriter.println("<table width='100%' border='1'>");
            printWriter.println("<tr>");
            printWriter.println("<td>");
            printWriter.println(WsservletMessages.SERVLET_HTML_COLUMN_HEADER_PORT_NAME());
            printWriter.println("</td>");
            printWriter.println("<td>");
            printWriter.println(WsservletMessages.SERVLET_HTML_COLUMN_HEADER_INFORMATION());
            printWriter.println("</td>");
            printWriter.println("</tr>");
            for (BoundEndpoint boundEndpoint : list) {
                String string = boundEndpoint.getAddress(wSHTTPConnection.getBaseAddress()).toString();
                printWriter.println("<tr>");
                printWriter.println("<td>");
                printWriter.println(WsservletMessages.SERVLET_HTML_ENDPOINT_TABLE(boundEndpoint.getEndpoint().getServiceName(), boundEndpoint.getEndpoint().getPortName()));
                printWriter.println("</td>");
                printWriter.println("<td>");
                printWriter.println(WsservletMessages.SERVLET_HTML_INFORMATION_TABLE(string, boundEndpoint.getEndpoint().getImplementationClass().getName()));
                printWriter.println("</td>");
                printWriter.println("</tr>");
            }
            printWriter.println("</table>");
        }
        printWriter.println("</body>");
        printWriter.println("</html>");
        printWriter.close();
    }

    public static synchronized void setPublishStatus(boolean bl) {
        publishStatusPage = bl;
    }

    public static void setDump(boolean bl) {
        dump = bl;
    }

    static {
        block8: {
            block7: {
                block6: {
                    LOGGER = Logger.getLogger(HttpAdapter.class.getName());
                    NO_OP_COMPLETION_CALLBACK = new CompletionCallback(){

                        @Override
                        public void onCompletion() {
                        }
                    };
                    dump = false;
                    dump_threshold = 4096;
                    publishStatusPage = true;
                    try {
                        dump = Boolean.getBoolean(HttpAdapter.class.getName() + ".dump");
                    }
                    catch (SecurityException securityException) {
                        if (!LOGGER.isLoggable(Level.CONFIG)) break block6;
                        LOGGER.log(Level.CONFIG, "Cannot read ''{0}'' property, using defaults.", new Object[]{HttpAdapter.class.getName() + ".dump"});
                    }
                }
                try {
                    dump_threshold = Integer.getInteger(HttpAdapter.class.getName() + ".dumpTreshold", 4096);
                }
                catch (SecurityException securityException) {
                    if (!LOGGER.isLoggable(Level.CONFIG)) break block7;
                    LOGGER.log(Level.CONFIG, "Cannot read ''{0}'' property, using defaults.", new Object[]{HttpAdapter.class.getName() + ".dumpTreshold"});
                }
            }
            try {
                HttpAdapter.setPublishStatus(Boolean.getBoolean(HttpAdapter.class.getName() + ".publishStatusPage"));
            }
            catch (SecurityException securityException) {
                if (!LOGGER.isLoggable(Level.CONFIG)) break block8;
                LOGGER.log(Level.CONFIG, "Cannot read ''{0}'' property, using defaults.", new Object[]{HttpAdapter.class.getName() + ".publishStatusPage"});
            }
        }
    }

    final class AsyncTransport
    extends AbstractServerAsyncTransport<WSHTTPConnection> {
        public AsyncTransport() {
            super(HttpAdapter.this.endpoint);
        }

        public void handleAsync(WSHTTPConnection wSHTTPConnection) throws IOException {
            super.handle(wSHTTPConnection);
        }

        @Override
        protected void encodePacket(WSHTTPConnection wSHTTPConnection, @NotNull Packet packet, @NotNull Codec codec) throws IOException {
            HttpAdapter.this.encodePacket(packet, wSHTTPConnection, codec);
        }

        @Override
        @Nullable
        protected String getAcceptableMimeTypes(WSHTTPConnection wSHTTPConnection) {
            return null;
        }

        @Override
        @Nullable
        protected TransportBackChannel getTransportBackChannel(WSHTTPConnection wSHTTPConnection) {
            return new Oneway(wSHTTPConnection);
        }

        @Override
        @NotNull
        protected PropertySet getPropertySet(WSHTTPConnection wSHTTPConnection) {
            return wSHTTPConnection;
        }

        @Override
        @NotNull
        protected WebServiceContextDelegate getWebServiceContextDelegate(WSHTTPConnection wSHTTPConnection) {
            return wSHTTPConnection.getWebServiceContextDelegate();
        }
    }

    public static interface CompletionCallback {
        public void onCompletion();
    }

    private static final class DummyList
    extends HttpAdapterList<HttpAdapter> {
        private DummyList() {
        }

        @Override
        protected HttpAdapter createHttpAdapter(String string, String string2, WSEndpoint<?> wSEndpoint) {
            return new HttpAdapter(wSEndpoint, this, string2);
        }
    }

    private static final class Http10OutputStream
    extends ByteArrayBuffer {
        private final WSHTTPConnection con;

        Http10OutputStream(WSHTTPConnection wSHTTPConnection) {
            this.con = wSHTTPConnection;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.con.setContentLengthResponseHeader(this.size());
            OutputStream outputStream = this.con.getOutput();
            this.writeTo(outputStream);
            outputStream.close();
        }
    }

    final class HttpToolkit
    extends Adapter.Toolkit {
        HttpToolkit() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(WSHTTPConnection wSHTTPConnection) throws IOException {
            try {
                Packet packet;
                boolean bl = false;
                try {
                    packet = HttpAdapter.this.decodePacket(wSHTTPConnection, this.codec);
                    bl = true;
                }
                catch (Exception exception) {
                    packet = new Packet();
                    if (exception instanceof ExceptionHasMessage) {
                        LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
                        packet.setMessage(((ExceptionHasMessage)exception).getFaultMessage());
                    }
                    if (exception instanceof UnsupportedMediaException) {
                        LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
                        wSHTTPConnection.setStatus(415);
                    }
                    LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
                    wSHTTPConnection.setStatus(500);
                }
                if (bl) {
                    try {
                        packet = this.head.process(packet, wSHTTPConnection.getWebServiceContextDelegate(), packet.transportBackChannel);
                    }
                    catch (Throwable throwable) {
                        LOGGER.log(Level.SEVERE, throwable.getMessage(), throwable);
                        if (!wSHTTPConnection.isClosed()) {
                            HttpAdapter.this.writeInternalServerError(wSHTTPConnection);
                        }
                        if (!wSHTTPConnection.isClosed()) {
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.log(Level.FINE, "Closing HTTP Connection with status: {0}", wSHTTPConnection.getStatus());
                            }
                            wSHTTPConnection.close();
                        }
                        return;
                    }
                }
                HttpAdapter.this.encodePacket(packet, wSHTTPConnection, this.codec);
            }
            finally {
                if (!wSHTTPConnection.isClosed()) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Closing HTTP Connection with status: {0}", wSHTTPConnection.getStatus());
                    }
                    wSHTTPConnection.close();
                }
            }
        }
    }

    static final class Oneway
    implements TransportBackChannel {
        WSHTTPConnection con;
        boolean closed;

        Oneway(WSHTTPConnection wSHTTPConnection) {
            this.con = wSHTTPConnection;
        }

        @Override
        public void close() {
            if (!this.closed) {
                this.closed = true;
                if (this.con.getStatus() == 0) {
                    this.con.setStatus(202);
                }
                OutputStream outputStream = null;
                try {
                    outputStream = this.con.getOutput();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (dump || LOGGER.isLoggable(Level.FINER)) {
                    try {
                        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
                        HttpAdapter.dump(byteArrayBuffer, "HTTP response " + this.con.getStatus(), this.con.getResponseHeaders());
                    }
                    catch (Exception exception) {
                        throw new WebServiceException(exception.toString(), exception);
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {
                        throw new WebServiceException(iOException);
                    }
                }
                this.con.close();
            }
        }
    }
}

