/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.wsdl;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.SEIModel;
import com.sun.xml.internal.ws.api.model.WSDLOperationMapping;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.fault.SOAPFaultBuilder;
import com.sun.xml.internal.ws.resources.ServerMessages;
import com.sun.xml.internal.ws.wsdl.ActionBasedOperationFinder;
import com.sun.xml.internal.ws.wsdl.DispatchException;
import com.sun.xml.internal.ws.wsdl.PayloadQNameBasedOperationFinder;
import com.sun.xml.internal.ws.wsdl.SOAPActionBasedOperationFinder;
import com.sun.xml.internal.ws.wsdl.WSDLOperationFinder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;

public class OperationDispatcher {
    private List<WSDLOperationFinder> opFinders;
    private WSBinding binding;

    public OperationDispatcher(@NotNull WSDLPort wSDLPort, @NotNull WSBinding wSBinding, @Nullable SEIModel sEIModel) {
        this.binding = wSBinding;
        this.opFinders = new ArrayList<WSDLOperationFinder>();
        if (wSBinding.getAddressingVersion() != null) {
            this.opFinders.add(new ActionBasedOperationFinder(wSDLPort, wSBinding, sEIModel));
        }
        this.opFinders.add(new PayloadQNameBasedOperationFinder(wSDLPort, wSBinding, sEIModel));
        this.opFinders.add(new SOAPActionBasedOperationFinder(wSDLPort, wSBinding, sEIModel));
    }

    @NotNull
    public QName getWSDLOperationQName(Packet packet) throws DispatchException {
        WSDLOperationMapping wSDLOperationMapping = this.getWSDLOperationMapping(packet);
        return wSDLOperationMapping != null ? wSDLOperationMapping.getOperationName() : null;
    }

    @NotNull
    public WSDLOperationMapping getWSDLOperationMapping(Packet packet) throws DispatchException {
        for (WSDLOperationFinder object2 : this.opFinders) {
            WSDLOperationMapping wSDLOperationMapping = object2.getWSDLOperationMapping(packet);
            if (wSDLOperationMapping == null) continue;
            return wSDLOperationMapping;
        }
        String string = MessageFormat.format("Request=[SOAPAction={0},Payload='{'{1}'}'{2}]", packet.soapAction, packet.getMessage().getPayloadNamespaceURI(), packet.getMessage().getPayloadLocalPart());
        String string2 = ServerMessages.DISPATCH_CANNOT_FIND_METHOD(string);
        Message message = SOAPFaultBuilder.createSOAPFaultMessage(this.binding.getSOAPVersion(), string2, this.binding.getSOAPVersion().faultCodeClient);
        throw new DispatchException(message);
    }
}

