/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.wsdl.writer;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.addressing.W3CAddressingConstants;
import com.sun.xml.internal.ws.addressing.v200408.MemberSubmissionAddressingConstants;
import com.sun.xml.internal.ws.api.server.PortAddressResolver;
import com.sun.xml.internal.ws.util.xml.XMLStreamReaderToXMLStreamWriter;
import com.sun.xml.internal.ws.wsdl.parser.WSDLConstants;
import com.sun.xml.internal.ws.wsdl.writer.DocumentLocationResolver;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class WSDLPatcher
extends XMLStreamReaderToXMLStreamWriter {
    private static final String NS_XSD = "http://www.w3.org/2001/XMLSchema";
    private static final QName SCHEMA_INCLUDE_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "include");
    private static final QName SCHEMA_IMPORT_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "import");
    private static final QName SCHEMA_REDEFINE_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "redefine");
    private static final Logger logger = Logger.getLogger("com.sun.xml.internal.ws.wsdl.patcher");
    private final DocumentLocationResolver docResolver;
    private final PortAddressResolver portAddressResolver;
    private String targetNamespace;
    private QName serviceName;
    private QName portName;
    private String portAddress;
    private boolean inEpr;
    private boolean inEprAddress;

    public WSDLPatcher(@NotNull PortAddressResolver portAddressResolver, @NotNull DocumentLocationResolver documentLocationResolver) {
        this.portAddressResolver = portAddressResolver;
        this.docResolver = documentLocationResolver;
    }

    @Override
    protected void handleAttribute(int n) throws XMLStreamException {
        QName qName = this.in.getName();
        String string = this.in.getAttributeLocalName(n);
        if (qName.equals(SCHEMA_INCLUDE_QNAME) && string.equals("schemaLocation") || qName.equals(SCHEMA_IMPORT_QNAME) && string.equals("schemaLocation") || qName.equals(SCHEMA_REDEFINE_QNAME) && string.equals("schemaLocation") || qName.equals(WSDLConstants.QNAME_IMPORT) && string.equals("location")) {
            String string2 = this.in.getAttributeValue(n);
            String string3 = this.getPatchedImportLocation(string2);
            if (string3 == null) {
                return;
            }
            logger.fine("Fixing the relative location:" + string2 + " with absolute location:" + string3);
            this.writeAttribute(n, string3);
            return;
        }
        if ((qName.equals(WSDLConstants.NS_SOAP_BINDING_ADDRESS) || qName.equals(WSDLConstants.NS_SOAP12_BINDING_ADDRESS)) && string.equals("location")) {
            this.portAddress = this.in.getAttributeValue(n);
            String string4 = this.getAddressLocation();
            if (string4 != null) {
                logger.fine("Service:" + this.serviceName + " port:" + this.portName + " current address " + this.portAddress + " Patching it with " + string4);
                this.writeAttribute(n, string4);
                return;
            }
        }
        super.handleAttribute(n);
    }

    private void writeAttribute(int n, String string) throws XMLStreamException {
        String string2 = this.in.getAttributeNamespace(n);
        if (string2 != null) {
            this.out.writeAttribute(this.in.getAttributePrefix(n), string2, this.in.getAttributeLocalName(n), string);
        } else {
            this.out.writeAttribute(this.in.getAttributeLocalName(n), string);
        }
    }

    @Override
    protected void handleStartElement() throws XMLStreamException {
        QName qName = this.in.getName();
        if (qName.equals(WSDLConstants.QNAME_DEFINITIONS)) {
            String string = this.in.getAttributeValue(null, "targetNamespace");
            if (string != null) {
                this.targetNamespace = string;
            }
        } else if (qName.equals(WSDLConstants.QNAME_SERVICE)) {
            String string = this.in.getAttributeValue(null, "name");
            if (string != null) {
                this.serviceName = new QName(this.targetNamespace, string);
            }
        } else if (qName.equals(WSDLConstants.QNAME_PORT)) {
            String string = this.in.getAttributeValue(null, "name");
            if (string != null) {
                this.portName = new QName(this.targetNamespace, string);
            }
        } else if (qName.equals(W3CAddressingConstants.WSA_EPR_QNAME) || qName.equals(MemberSubmissionAddressingConstants.WSA_EPR_QNAME)) {
            if (this.serviceName != null && this.portName != null) {
                this.inEpr = true;
            }
        } else if ((qName.equals(W3CAddressingConstants.WSA_ADDRESS_QNAME) || qName.equals(MemberSubmissionAddressingConstants.WSA_ADDRESS_QNAME)) && this.inEpr) {
            this.inEprAddress = true;
        }
        super.handleStartElement();
    }

    @Override
    protected void handleEndElement() throws XMLStreamException {
        QName qName = this.in.getName();
        if (qName.equals(WSDLConstants.QNAME_SERVICE)) {
            this.serviceName = null;
        } else if (qName.equals(WSDLConstants.QNAME_PORT)) {
            this.portName = null;
        } else if (qName.equals(W3CAddressingConstants.WSA_EPR_QNAME) || qName.equals(MemberSubmissionAddressingConstants.WSA_EPR_QNAME)) {
            if (this.inEpr) {
                this.inEpr = false;
            }
        } else if ((qName.equals(W3CAddressingConstants.WSA_ADDRESS_QNAME) || qName.equals(MemberSubmissionAddressingConstants.WSA_ADDRESS_QNAME)) && this.inEprAddress) {
            String string = this.getAddressLocation();
            if (string != null) {
                logger.fine("Fixing EPR Address for service:" + this.serviceName + " port:" + this.portName + " address with " + string);
                this.out.writeCharacters(string);
            }
            this.inEprAddress = false;
        }
        super.handleEndElement();
    }

    @Override
    protected void handleCharacters() throws XMLStreamException {
        String string;
        if (this.inEprAddress && (string = this.getAddressLocation()) != null) {
            return;
        }
        super.handleCharacters();
    }

    @Nullable
    private String getPatchedImportLocation(String string) {
        return this.docResolver.getLocationFor(null, string);
    }

    private String getAddressLocation() {
        return this.portAddressResolver == null || this.portName == null ? null : this.portAddressResolver.getAddressFor(this.serviceName, this.portName.getLocalPart(), this.portAddress);
    }
}

