/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;
import sun.misc.Unsafe;

public class Random
implements Serializable {
    static final long serialVersionUID = 3905348978240129619L;
    private final AtomicLong seed;
    private static final long multiplier = 25214903917L;
    private static final long addend = 11L;
    private static final long mask = 0xFFFFFFFFFFFFL;
    private static final double DOUBLE_UNIT = (double)1.110223E-16f;
    static final String BadBound = "bound must be positive";
    static final String BadRange = "bound must be greater than origin";
    static final String BadSize = "size must be non-negative";
    private static final AtomicLong seedUniquifier = new AtomicLong(8682522807148012L);
    private double nextNextGaussian;
    private boolean haveNextNextGaussian = false;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("seed", Long.TYPE), new ObjectStreamField("nextNextGaussian", Double.TYPE), new ObjectStreamField("haveNextNextGaussian", Boolean.TYPE)};
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final long seedOffset;

    public Random() {
        this(Random.seedUniquifier() ^ System.nanoTime());
    }

    private static long seedUniquifier() {
        long l;
        long l2;
        while (!seedUniquifier.compareAndSet(l2 = seedUniquifier.get(), l = l2 * 181783497276652981L)) {
        }
        return l;
    }

    public Random(long l) {
        if (this.getClass() == Random.class) {
            this.seed = new AtomicLong(Random.initialScramble(l));
        } else {
            this.seed = new AtomicLong();
            this.setSeed(l);
        }
    }

    private static long initialScramble(long l) {
        return (l ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
    }

    public synchronized void setSeed(long l) {
        this.seed.set(Random.initialScramble(l));
        this.haveNextNextGaussian = false;
    }

    protected int next(int n) {
        long l;
        long l2;
        AtomicLong atomicLong = this.seed;
        while (!atomicLong.compareAndSet(l2 = atomicLong.get(), l = l2 * 25214903917L + 11L & 0xFFFFFFFFFFFFL)) {
        }
        return (int)(l >>> 48 - n);
    }

    public void nextBytes(byte[] byArray) {
        int n = 0;
        int n2 = byArray.length;
        while (n < n2) {
            int n3 = this.nextInt();
            int n4 = Math.min(n2 - n, 4);
            while (n4-- > 0) {
                byArray[n++] = (byte)n3;
                n3 >>= 8;
            }
        }
    }

    final long internalNextLong(long l, long l2) {
        long l3 = this.nextLong();
        if (l < l2) {
            long l4 = l2 - l;
            long l5 = l4 - 1L;
            if ((l4 & l5) == 0L) {
                l3 = (l3 & l5) + l;
            } else if (l4 > 0L) {
                long l6 = l3 >>> 1;
                while (l6 + l5 - (l3 = l6 % l4) < 0L) {
                    l6 = this.nextLong() >>> 1;
                }
                l3 += l;
            } else {
                while (l3 < l || l3 >= l2) {
                    l3 = this.nextLong();
                }
            }
        }
        return l3;
    }

    final int internalNextInt(int n, int n2) {
        if (n < n2) {
            int n3;
            int n4 = n2 - n;
            if (n4 > 0) {
                return this.nextInt(n4) + n;
            }
            while ((n3 = this.nextInt()) < n || n3 >= n2) {
            }
            return n3;
        }
        return this.nextInt();
    }

    final double internalNextDouble(double d, double d2) {
        double d3 = this.nextDouble();
        if (d < d2 && (d3 = d3 * (d2 - d) + d) >= d2) {
            d3 = Double.longBitsToDouble(Double.doubleToLongBits(d2) - 1L);
        }
        return d3;
    }

    public int nextInt() {
        return this.next(32);
    }

    public int nextInt(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(BadBound);
        }
        int n2 = this.next(31);
        int n3 = n - 1;
        if ((n & n3) == 0) {
            n2 = (int)((long)n * (long)n2 >> 31);
        } else {
            int n4 = n2;
            while (n4 - (n2 = n4 % n) + n3 < 0) {
                n4 = this.next(31);
            }
        }
        return n2;
    }

    public long nextLong() {
        return ((long)this.next(32) << 32) + (long)this.next(32);
    }

    public boolean nextBoolean() {
        return this.next(1) != 0;
    }

    public float nextFloat() {
        return (float)this.next(24) / 1.6777216E7f;
    }

    public double nextDouble() {
        return (double)(((long)this.next(26) << 27) + (long)this.next(27)) * (double)1.110223E-16f;
    }

    public synchronized double nextGaussian() {
        double d;
        double d2;
        double d3;
        if (this.haveNextNextGaussian) {
            this.haveNextNextGaussian = false;
            return this.nextNextGaussian;
        }
        while ((d3 = (d2 = 2.0 * this.nextDouble() - 1.0) * d2 + (d = 2.0 * this.nextDouble() - 1.0) * d) >= 1.0 || d3 == 0.0) {
        }
        double d4 = StrictMath.sqrt(-2.0 * StrictMath.log(d3) / d3);
        this.nextNextGaussian = d * d4;
        this.haveNextNextGaussian = true;
        return d2 * d4;
    }

    public IntStream ints(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(BadSize);
        }
        return StreamSupport.intStream(new RandomIntsSpliterator(this, 0L, l, Integer.MAX_VALUE, 0), false);
    }

    public IntStream ints() {
        return StreamSupport.intStream(new RandomIntsSpliterator(this, 0L, Long.MAX_VALUE, Integer.MAX_VALUE, 0), false);
    }

    public IntStream ints(long l, int n, int n2) {
        if (l < 0L) {
            throw new IllegalArgumentException(BadSize);
        }
        if (n >= n2) {
            throw new IllegalArgumentException(BadRange);
        }
        return StreamSupport.intStream(new RandomIntsSpliterator(this, 0L, l, n, n2), false);
    }

    public IntStream ints(int n, int n2) {
        if (n >= n2) {
            throw new IllegalArgumentException(BadRange);
        }
        return StreamSupport.intStream(new RandomIntsSpliterator(this, 0L, Long.MAX_VALUE, n, n2), false);
    }

    public LongStream longs(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(BadSize);
        }
        return StreamSupport.longStream(new RandomLongsSpliterator(this, 0L, l, Long.MAX_VALUE, 0L), false);
    }

    public LongStream longs() {
        return StreamSupport.longStream(new RandomLongsSpliterator(this, 0L, Long.MAX_VALUE, Long.MAX_VALUE, 0L), false);
    }

    public LongStream longs(long l, long l2, long l3) {
        if (l < 0L) {
            throw new IllegalArgumentException(BadSize);
        }
        if (l2 >= l3) {
            throw new IllegalArgumentException(BadRange);
        }
        return StreamSupport.longStream(new RandomLongsSpliterator(this, 0L, l, l2, l3), false);
    }

    public LongStream longs(long l, long l2) {
        if (l >= l2) {
            throw new IllegalArgumentException(BadRange);
        }
        return StreamSupport.longStream(new RandomLongsSpliterator(this, 0L, Long.MAX_VALUE, l, l2), false);
    }

    public DoubleStream doubles(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(BadSize);
        }
        return StreamSupport.doubleStream(new RandomDoublesSpliterator(this, 0L, l, Double.MAX_VALUE, 0.0), false);
    }

    public DoubleStream doubles() {
        return StreamSupport.doubleStream(new RandomDoublesSpliterator(this, 0L, Long.MAX_VALUE, Double.MAX_VALUE, 0.0), false);
    }

    public DoubleStream doubles(long l, double d, double d2) {
        if (l < 0L) {
            throw new IllegalArgumentException(BadSize);
        }
        if (!(d < d2)) {
            throw new IllegalArgumentException(BadRange);
        }
        return StreamSupport.doubleStream(new RandomDoublesSpliterator(this, 0L, l, d, d2), false);
    }

    public DoubleStream doubles(double d, double d2) {
        if (!(d < d2)) {
            throw new IllegalArgumentException(BadRange);
        }
        return StreamSupport.doubleStream(new RandomDoublesSpliterator(this, 0L, Long.MAX_VALUE, d, d2), false);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        long l = getField.get("seed", -1L);
        if (l < 0L) {
            throw new StreamCorruptedException("Random: invalid seed");
        }
        this.resetSeed(l);
        this.nextNextGaussian = getField.get("nextNextGaussian", 0.0);
        this.haveNextNextGaussian = getField.get("haveNextNextGaussian", false);
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("seed", this.seed.get());
        putField.put("nextNextGaussian", this.nextNextGaussian);
        putField.put("haveNextNextGaussian", this.haveNextNextGaussian);
        objectOutputStream.writeFields();
    }

    private void resetSeed(long l) {
        unsafe.putObjectVolatile(this, seedOffset, new AtomicLong(l));
    }

    static {
        try {
            seedOffset = unsafe.objectFieldOffset(Random.class.getDeclaredField("seed"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    static final class RandomDoublesSpliterator
    implements Spliterator.OfDouble {
        final Random rng;
        long index;
        final long fence;
        final double origin;
        final double bound;

        RandomDoublesSpliterator(Random random, long l, long l2, double d, double d2) {
            this.rng = random;
            this.index = l;
            this.fence = l2;
            this.origin = d;
            this.bound = d2;
        }

        @Override
        public RandomDoublesSpliterator trySplit() {
            RandomDoublesSpliterator randomDoublesSpliterator;
            long l = this.index;
            long l2 = l + this.fence >>> 1;
            if (l2 <= l) {
                randomDoublesSpliterator = null;
            } else {
                this.index = l2;
                RandomDoublesSpliterator randomDoublesSpliterator2 = new RandomDoublesSpliterator(this.rng, l, this.index, this.origin, this.bound);
                randomDoublesSpliterator = randomDoublesSpliterator2;
            }
            return randomDoublesSpliterator;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return 17728;
        }

        @Override
        public boolean tryAdvance(DoubleConsumer doubleConsumer) {
            if (doubleConsumer == null) {
                throw new NullPointerException();
            }
            long l = this.index;
            long l2 = this.fence;
            if (l < l2) {
                doubleConsumer.accept(this.rng.internalNextDouble(this.origin, this.bound));
                this.index = l + 1L;
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(DoubleConsumer doubleConsumer) {
            if (doubleConsumer == null) {
                throw new NullPointerException();
            }
            long l = this.index;
            long l2 = this.fence;
            if (l < l2) {
                this.index = l2;
                Random random = this.rng;
                double d = this.origin;
                double d2 = this.bound;
                do {
                    doubleConsumer.accept(random.internalNextDouble(d, d2));
                } while (++l < l2);
            }
        }
    }

    static final class RandomIntsSpliterator
    implements Spliterator.OfInt {
        final Random rng;
        long index;
        final long fence;
        final int origin;
        final int bound;

        RandomIntsSpliterator(Random random, long l, long l2, int n, int n2) {
            this.rng = random;
            this.index = l;
            this.fence = l2;
            this.origin = n;
            this.bound = n2;
        }

        @Override
        public RandomIntsSpliterator trySplit() {
            RandomIntsSpliterator randomIntsSpliterator;
            long l = this.index;
            long l2 = l + this.fence >>> 1;
            if (l2 <= l) {
                randomIntsSpliterator = null;
            } else {
                this.index = l2;
                RandomIntsSpliterator randomIntsSpliterator2 = new RandomIntsSpliterator(this.rng, l, this.index, this.origin, this.bound);
                randomIntsSpliterator = randomIntsSpliterator2;
            }
            return randomIntsSpliterator;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return 17728;
        }

        @Override
        public boolean tryAdvance(IntConsumer intConsumer) {
            if (intConsumer == null) {
                throw new NullPointerException();
            }
            long l = this.index;
            long l2 = this.fence;
            if (l < l2) {
                intConsumer.accept(this.rng.internalNextInt(this.origin, this.bound));
                this.index = l + 1L;
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(IntConsumer intConsumer) {
            if (intConsumer == null) {
                throw new NullPointerException();
            }
            long l = this.index;
            long l2 = this.fence;
            if (l < l2) {
                this.index = l2;
                Random random = this.rng;
                int n = this.origin;
                int n2 = this.bound;
                do {
                    intConsumer.accept(random.internalNextInt(n, n2));
                } while (++l < l2);
            }
        }
    }

    static final class RandomLongsSpliterator
    implements Spliterator.OfLong {
        final Random rng;
        long index;
        final long fence;
        final long origin;
        final long bound;

        RandomLongsSpliterator(Random random, long l, long l2, long l3, long l4) {
            this.rng = random;
            this.index = l;
            this.fence = l2;
            this.origin = l3;
            this.bound = l4;
        }

        @Override
        public RandomLongsSpliterator trySplit() {
            RandomLongsSpliterator randomLongsSpliterator;
            long l = this.index;
            long l2 = l + this.fence >>> 1;
            if (l2 <= l) {
                randomLongsSpliterator = null;
            } else {
                this.index = l2;
                RandomLongsSpliterator randomLongsSpliterator2 = new RandomLongsSpliterator(this.rng, l, this.index, this.origin, this.bound);
                randomLongsSpliterator = randomLongsSpliterator2;
            }
            return randomLongsSpliterator;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return 17728;
        }

        @Override
        public boolean tryAdvance(LongConsumer longConsumer) {
            if (longConsumer == null) {
                throw new NullPointerException();
            }
            long l = this.index;
            long l2 = this.fence;
            if (l < l2) {
                longConsumer.accept(this.rng.internalNextLong(this.origin, this.bound));
                this.index = l + 1L;
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(LongConsumer longConsumer) {
            if (longConsumer == null) {
                throw new NullPointerException();
            }
            long l = this.index;
            long l2 = this.fence;
            if (l < l2) {
                this.index = l2;
                Random random = this.rng;
                long l3 = this.origin;
                long l4 = this.bound;
                do {
                    longConsumer.accept(random.internalNextLong(l3, l4));
                } while (++l < l2);
            }
        }
    }
}

