/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicDesktopIconUI;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthInternalFrameTitlePane;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthUI;

public class SynthDesktopIconUI
extends BasicDesktopIconUI
implements SynthUI,
PropertyChangeListener {
    private SynthStyle style;
    private Handler handler = new Handler();

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthDesktopIconUI();
    }

    @Override
    protected void installComponents() {
        if (UIManager.getBoolean("InternalFrame.useTaskBar")) {
            this.iconPane = new JToggleButton(this.frame.getTitle(), this.frame.getFrameIcon()){

                @Override
                public String getToolTipText() {
                    return this.getText();
                }

                @Override
                public JPopupMenu getComponentPopupMenu() {
                    return SynthDesktopIconUI.this.frame.getComponentPopupMenu();
                }
            };
            ToolTipManager.sharedInstance().registerComponent(this.iconPane);
            this.iconPane.setFont(this.desktopIcon.getFont());
            this.iconPane.setBackground(this.desktopIcon.getBackground());
            this.iconPane.setForeground(this.desktopIcon.getForeground());
        } else {
            this.iconPane = new SynthInternalFrameTitlePane(this.frame);
            this.iconPane.setName("InternalFrame.northPane");
        }
        this.desktopIcon.setLayout(new BorderLayout());
        this.desktopIcon.add((Component)this.iconPane, "Center");
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.desktopIcon.addPropertyChangeListener(this);
        if (this.iconPane instanceof JToggleButton) {
            this.frame.addPropertyChangeListener(this);
            ((JToggleButton)this.iconPane).addActionListener(this.handler);
        }
    }

    @Override
    protected void uninstallListeners() {
        if (this.iconPane instanceof JToggleButton) {
            ((JToggleButton)this.iconPane).removeActionListener(this.handler);
            this.frame.removePropertyChangeListener(this);
        }
        this.desktopIcon.removePropertyChangeListener(this);
        super.uninstallListeners();
    }

    @Override
    protected void installDefaults() {
        this.updateStyle(this.desktopIcon);
    }

    private void updateStyle(JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent, 1);
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
    }

    @Override
    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext(this.desktopIcon, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    @Override
    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(jComponent, this.style, n);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintDesktopIconBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
    }

    @Override
    public void paintBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        synthContext.getPainter().paintDesktopIconBorder(synthContext, graphics, n, n2, n3, n4);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() instanceof JInternalFrame.JDesktopIcon) {
            if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
                this.updateStyle((JInternalFrame.JDesktopIcon)propertyChangeEvent.getSource());
            }
        } else if (propertyChangeEvent.getSource() instanceof JInternalFrame) {
            JInternalFrame jInternalFrame = (JInternalFrame)propertyChangeEvent.getSource();
            if (this.iconPane instanceof JToggleButton) {
                JToggleButton jToggleButton = (JToggleButton)this.iconPane;
                String string = propertyChangeEvent.getPropertyName();
                if (string == "title") {
                    jToggleButton.setText((String)propertyChangeEvent.getNewValue());
                } else if (string == "frameIcon") {
                    jToggleButton.setIcon((Icon)propertyChangeEvent.getNewValue());
                } else if (string == "icon" || string == "selected") {
                    jToggleButton.setSelected(!jInternalFrame.isIcon() && jInternalFrame.isSelected());
                }
            }
        }
    }

    private final class Handler
    implements ActionListener {
        private Handler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof JToggleButton) {
                JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
                try {
                    boolean bl = jToggleButton.isSelected();
                    if (!bl && !SynthDesktopIconUI.this.frame.isIconifiable()) {
                        jToggleButton.setSelected(true);
                    } else {
                        SynthDesktopIconUI.this.frame.setIcon(!bl);
                        if (bl) {
                            SynthDesktopIconUI.this.frame.setSelected(true);
                        }
                    }
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }
}

