/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.ssl.jdbc4;

import java.io.Console;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.postgresql.ssl.NonValidatingFactory;
import org.postgresql.ssl.WrappedFactory;
import org.postgresql.ssl.jdbc4.AbstractJdbc4MakeSSL;
import org.postgresql.ssl.jdbc4.LazyKeyManager;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class LibPQFactory
extends WrappedFactory
implements HostnameVerifier {
    LazyKeyManager km = null;
    String sslmode;

    public LibPQFactory(Properties info) throws PSQLException {
        try {
            TrustManager[] tm;
            CallbackHandler cbh;
            String sslpasswordcallback;
            String sslkeyfile;
            this.sslmode = info.getProperty("sslmode");
            SSLContext ctx = SSLContext.getInstance("TLS");
            String pathsep = System.getProperty("file.separator");
            boolean defaultfile = false;
            String defaultdir = System.getProperty("os.name").toLowerCase().indexOf("windows") > -1 ? System.getenv("APPDATA") + pathsep + "postgresql" + pathsep : System.getProperty("user.home") + pathsep + ".postgresql" + pathsep;
            String sslcertfile = info.getProperty("sslcert");
            if (sslcertfile == null) {
                defaultfile = true;
                sslcertfile = defaultdir + "postgresql.crt";
            }
            if ((sslkeyfile = info.getProperty("sslkey")) == null) {
                defaultfile = true;
                sslkeyfile = defaultdir + "postgresql.pk8";
            }
            if ((sslpasswordcallback = info.getProperty("sslpasswordcallback")) != null) {
                try {
                    cbh = (CallbackHandler)AbstractJdbc4MakeSSL.instantiate(sslpasswordcallback, info, false, null);
                }
                catch (Exception e) {
                    throw new PSQLException(GT.tr("The password callback class provided {0} could not be instantiated.", sslpasswordcallback), PSQLState.CONNECTION_FAILURE, (Throwable)e);
                }
            } else {
                cbh = new ConsoleCallbackHandler(info.getProperty("sslpassword"));
            }
            this.km = new LazyKeyManager("".equals(sslcertfile) ? null : sslcertfile, "".equals(sslkeyfile) ? null : sslkeyfile, cbh, defaultfile);
            if ("verify-ca".equals(this.sslmode) || "verify-full".equals(this.sslmode)) {
                FileInputStream fis;
                KeyStore ks;
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("PKIX");
                try {
                    ks = KeyStore.getInstance("jks");
                }
                catch (KeyStoreException e) {
                    throw new NoSuchAlgorithmException("jks KeyStore not available");
                }
                String sslrootcertfile = info.getProperty("sslrootcert");
                if (sslrootcertfile == null) {
                    sslrootcertfile = defaultdir + "root.crt";
                }
                try {
                    fis = new FileInputStream(sslrootcertfile);
                }
                catch (FileNotFoundException ex) {
                    throw new PSQLException(GT.tr("Could not open SSL root certificate file {0}.", new Object[]{sslrootcertfile}), PSQLState.CONNECTION_FAILURE, (Throwable)ex);
                }
                try {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    Certificate[] certs = cf.generateCertificates(fis).toArray(new Certificate[0]);
                    fis.close();
                    ks.load(null, null);
                    for (int i = 0; i < certs.length; ++i) {
                        ks.setCertificateEntry("cert" + i, certs[i]);
                    }
                    tmf.init(ks);
                }
                catch (IOException ioex) {
                    throw new PSQLException(GT.tr("Could not read SSL root certificate file {0}.", new Object[]{sslrootcertfile}), PSQLState.CONNECTION_FAILURE, (Throwable)ioex);
                }
                catch (GeneralSecurityException gsex) {
                    throw new PSQLException(GT.tr("Loading the SSL root certificate {0} into a TrustManager failed.", new Object[]{sslrootcertfile}), PSQLState.CONNECTION_FAILURE, (Throwable)gsex);
                }
                tm = tmf.getTrustManagers();
            } else {
                tm = new TrustManager[]{new NonValidatingFactory.NonValidatingTM()};
            }
            try {
                ctx.init(new KeyManager[]{this.km}, tm, null);
            }
            catch (KeyManagementException ex) {
                throw new PSQLException(GT.tr("Could not initialize SSL context.", null), PSQLState.CONNECTION_FAILURE, (Throwable)ex);
            }
            this._factory = ctx.getSocketFactory();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new PSQLException(GT.tr("Could not find a java cryptographic algorithm: {0}.", new Object[]{ex.getMessage()}), PSQLState.CONNECTION_FAILURE, (Throwable)ex);
        }
    }

    public void throwKeyManagerException() throws PSQLException {
        if (this.km != null) {
            this.km.throwKeyManagerException();
        }
    }

    @Override
    public boolean verify(String hostname, SSLSession session) {
        LdapName DN;
        X509Certificate[] peerCerts;
        try {
            peerCerts = (X509Certificate[])session.getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException e) {
            return false;
        }
        if (peerCerts == null || peerCerts.length == 0) {
            return false;
        }
        X509Certificate serverCert = peerCerts[0];
        try {
            DN = new LdapName(serverCert.getSubjectX500Principal().getName("RFC2253"));
        }
        catch (InvalidNameException e) {
            return false;
        }
        String CN = null;
        for (Rdn rdn : DN.getRdns()) {
            if (!"CN".equals(rdn.getType())) continue;
            CN = (String)rdn.getValue();
            break;
        }
        if (CN == null) {
            return false;
        }
        if (CN.startsWith("*")) {
            if (hostname.endsWith(CN.substring(1))) {
                return !hostname.substring(0, hostname.length() - CN.length() + 1).contains(".");
            }
            return false;
        }
        return CN.equals(hostname);
    }

    static class ConsoleCallbackHandler
    implements CallbackHandler {
        private char[] password = null;

        public ConsoleCallbackHandler(String password) {
            if (password != null) {
                this.password = password.toCharArray();
            }
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            Console cons = System.console();
            if (cons == null && this.password == null) {
                throw new UnsupportedCallbackException(callbacks[0], "Console is not available");
            }
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof PasswordCallback) {
                    if (this.password == null) {
                        ((PasswordCallback)callbacks[i]).setPassword(cons.readPassword("%s", ((PasswordCallback)callbacks[i]).getPrompt()));
                        continue;
                    }
                    ((PasswordCallback)callbacks[i]).setPassword(this.password);
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i]);
            }
        }
    }
}

