/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.system;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.hyperic.hq.pdh.MultipleCollectQueryPdh;
import org.hyperic.hq.plugin.system.LinuxCollector;
import org.hyperic.hq.plugin.system.LinuxVMStatsCollector;
import org.hyperic.hq.plugin.system.OtherUnixCollector;
import org.hyperic.hq.plugin.system.SystemPDHCollector;
import org.hyperic.hq.plugin.system.SystemPlugin;
import org.hyperic.hq.product.Collector;
import org.hyperic.hq.product.MeasurementPlugin;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricInvalidException;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.SigarMeasurementPlugin;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.ProcState;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.ptql.ProcessQuery;
import org.hyperic.sigar.ptql.ProcessQueryFactory;
import org.hyperic.sigar.win32.Pdh;
import org.hyperic.sigar.win32.Win32Exception;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;

public class SystemMeasurementPlugin
extends SigarMeasurementPlugin {
    private void reportError(Metric metric, Exception e) {
        this.getLog().error((Object)(metric + ": " + e.getMessage()), (Throwable)e);
        this.getManager().reportEvent(metric, System.currentTimeMillis(), 3, "system", e.getMessage());
    }

    private MetricValue getPdhValue(Metric metric) throws PluginException {
        String obj = "\\" + metric.getObjectPropString() + "\\" + metric.getAttributeName();
        try {
            Double val = new Pdh().getRawValue(obj);
            return new MetricValue((Number)val);
        }
        catch (Win32Exception e) {
            throw new PluginException((Throwable)e);
        }
    }

    private MetricValue getPdhValue2(Metric metric) {
        String prop = metric.getObjectPropString().replaceAll("%3A", ":");
        prop = prop.replaceAll("%26", "&");
        String obj = "\\" + prop + "\\";
        obj = metric.getAttributeName().startsWith("Memory ") ? obj + metric.getAttributeName().replace("Memory ", "") : obj + metric.getAttributeName();
        this.getLog().debug((Object)("[getPdhValue2] obj=" + obj));
        Double val = Double.NaN;
        try {
            val = MultipleCollectQueryPdh.getValue((String)obj);
        }
        catch (PluginException e) {
            this.getLog().debug((Object)("[getPdhValue2] obj=" + obj + " error:" + (Object)((Object)e)), (Throwable)e);
        }
        catch (Win32Exception e) {
            this.getLog().debug((Object)("[getPdhValue2] obj=" + obj + " error:" + (Object)((Object)e)), (Throwable)e);
        }
        return new MetricValue((Number)val);
    }

    public MetricValue getValue(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        this.getLog().debug((Object)("[getValue] '" + this.getTypeInfo().getName() + "' metric:" + metric));
        String domain = metric.getDomainName();
        if (domain.equals("blockdev") || domain.equals("page")) {
            return Collector.getValue((MeasurementPlugin)this, (Metric)metric);
        }
        if (domain.equals("pdh2")) {
            if ("formated".equals(metric.getObjectProperties().get("type"))) {
                return Collector.getValue((MeasurementPlugin)this, (Metric)metric);
            }
            return this.getPdhValue2(metric);
        }
        if (domain.equalsIgnoreCase("calculated")) {
            double res = 0.0;
            try {
                FileSystem[] fslist;
                for (FileSystem fs : fslist = this.getSigar().getFileSystemList()) {
                    if (fs.getType() != 2) continue;
                    this.getLog().debug((Object)("[calculated] fs: " + fs.getDirName()));
                    FileSystemUsage fsu = this.getSigar().getMountedFileSystemUsage(fs.getDirName());
                    if (metric.getAttributeName().equals("capacity")) {
                        res += (double)fsu.getTotal();
                        continue;
                    }
                    if (metric.getAttributeName().equals("usage")) {
                        res += (double)fsu.getUsed();
                        continue;
                    }
                    this.getLog().debug((Object)("[calculated] " + metric.getAttributeName() + " not supported."));
                    return MetricValue.NONE;
                }
            }
            catch (SigarException ex) {
                this.getLog().debug((Object)ex, (Throwable)ex);
            }
            return new MetricValue(res);
        }
        if (domain.equals("disk.avail")) {
            return this.getDiskAvail(metric);
        }
        if (domain.equals("pdh")) {
            return this.getPdhValue(metric);
        }
        Properties props = metric.getObjectProperties();
        String type = props.getProperty("Type");
        if (type == null) {
            String errMsg = "No type for metric [" + metric.getAttributeName() + "]";
            throw new MetricNotFoundException(errMsg);
        }
        boolean isFsUsage = type.endsWith("FileSystemUsage");
        if (domain.equals("sigar.ext")) {
            if (type.equals("CpuInfo")) {
                return new MetricValue(this.getNumCpus());
            }
            if (type.equals("DiskUsage")) {
                String arg = props.getProperty("Arg");
                return new MetricValue(this.getDiskUsage(arg));
            }
            if (type.equals("ChildProcesses")) {
                String arg = props.getProperty("Arg");
                return new MetricValue(this.getChildProcessCount(arg));
            }
            if (type.equals("FileSystemInfo")) {
                return new MetricValue(this.getAverageReadWrites());
            }
        }
        if (type.equals("Platform")) {
            return new MetricValue(100.0);
        }
        if (type.equals("NetIfconfig")) {
            int value = (int)super.getValue(metric).getValue();
            double avail = (value & 1) > 0 && (value & 0x40) == 64 ? 100.0 : ((value & 1) > 0 ? 0.5 : 0.0);
            return new MetricValue(avail);
        }
        if (isFsUsage) {
            double avail;
            try {
                super.getValue(metric).getValue();
                avail = 100.0;
            }
            catch (Exception e) {
                avail = 0.0;
                this.reportError(metric, e);
            }
            return new MetricValue(avail);
        }
        if (type.equals("FileInfo") || type.equals("DirStats")) {
            double avail;
            String attr = metric.getAttributeName();
            try {
                double val = super.getValue(metric).getValue();
                avail = 100.0;
                if (attr.equals("Type") && val != 2.0) {
                    avail = 0.0;
                }
            }
            catch (MetricNotFoundException e) {
                avail = 0.0;
            }
            return new MetricValue(avail);
        }
        if (type.equals("CpuPercList")) {
            try {
                super.getValue(metric);
                return new MetricValue(100.0);
            }
            catch (Exception e) {
                return new MetricValue(0.0);
            }
        }
        if (type.equals("MultiProcCpu")) {
            double val = super.getValue(metric).getValue();
            if (val >= 1.0) {
                return new MetricValue(100.0);
            }
            return new MetricValue(0.0);
        }
        throw new MetricNotFoundException(metric.toString());
    }

    private MetricValue getDiskAvail(Metric metric) {
        MetricValue res = new MetricValue(0.0);
        String disk = metric.getObjectProperty("disk");
        String type = metric.getObjectProperty("type");
        try {
            List<String> disks = Arrays.asList(Pdh.getInstances((String)(type + "Disk")));
            this.getLog().debug((Object)("[getDiskAvail](" + type + ") disk='" + disk + "' disks=" + disks));
            if (disks.contains(disk)) {
                res = new MetricValue(100.0);
            }
        }
        catch (Win32Exception ex) {
            this.getLog().debug((Object)("[getDiskAvail](" + type + ") " + (Object)((Object)ex)), (Throwable)ex);
        }
        return res;
    }

    private MetricValue getAverageReadWrites() {
        try {
            Sigar sigar = this.getSigar();
            FileSystem[] fslist = sigar.getFileSystemList();
            long totalReadWrites = 0L;
            boolean found = false;
            int numOfFs = 0;
            for (int i = 0; i < fslist.length; ++i) {
                long writes;
                FileSystem fs = fslist[i];
                if (fs.getType() != 2) continue;
                ++numOfFs;
                String dirName = fs.getDirName();
                FileSystemUsage fsUsage = sigar.getMountedFileSystemUsage(dirName);
                if (fsUsage == null) continue;
                long reads = fsUsage.getDiskReads();
                if (reads >= 0L) {
                    found = true;
                    totalReadWrites += reads;
                }
                if ((writes = fsUsage.getDiskWrites()) < 0L) continue;
                totalReadWrites += writes;
                found = true;
            }
            if (found) {
                double averageReadsWrites = (double)totalReadWrites / (double)numOfFs;
                return new MetricValue(averageReadsWrites);
            }
            return MetricValue.NONE;
        }
        catch (Exception e) {
            return MetricValue.NONE;
        }
    }

    private double getChildProcessCount(String arg) throws MetricNotFoundException {
        try {
            Sigar s = this.getSigar();
            long[] processIds = s.getProcList();
            ProcessQuery query = ProcessQueryFactory.getInstance().getQuery(arg);
            long parentPid = query.findProcess(s);
            double count = 0.0;
            for (long pid : processIds) {
                try {
                    ProcState state = s.getProcState(pid);
                    if (parentPid != state.getPpid()) continue;
                    count += 1.0;
                }
                catch (SigarException e) {
                    // empty catch block
                }
            }
            return count;
        }
        catch (Exception e) {
            throw new MetricNotFoundException(e.getMessage(), (Throwable)e);
        }
    }

    private double getNumCpus() throws MetricNotFoundException {
        try {
            return this.getSigar().getCpuInfoList().length;
        }
        catch (Exception e) {
            throw new MetricNotFoundException(e.getMessage(), (Throwable)e);
        }
    }

    private long getDiskUsage(String arg) throws MetricNotFoundException {
        try {
            return this.getSigar().getDirUsage(arg).getDiskUsage();
        }
        catch (Exception e) {
            throw new MetricNotFoundException(e.getMessage(), (Throwable)e);
        }
    }

    public ConfigSchema getConfigSchema(TypeInfo info, ConfigResponse config) {
        ConfigSchema schema = new ConfigSchema();
        return schema;
    }

    public Collector getNewCollector() {
        this.getLog().debug((Object)("[getNewCollector] type: " + this.getTypeInfo().getName()));
        if (this.getPluginData().getPlugin("collector", this.getTypeInfo().getName()) == null) {
            this.getPluginData().addPlugin("collector", "Win32", SystemPDHCollector.class.getName());
            this.getPluginData().addPlugin("collector", "Linux", LinuxVMStatsCollector.class.getName());
            this.getPluginData().addPlugin("collector", "Solaris", OtherUnixCollector.class.getName());
            this.getPluginData().addPlugin("collector", "AIX", OtherUnixCollector.class.getName());
            this.getPluginData().addPlugin("collector", "HPUX", OtherUnixCollector.class.getName());
            this.getPluginData().addPlugin("collector", "FileServer Physical Disk", SystemPDHCollector.class.getName());
            this.getPluginData().addPlugin("collector", "FileServer Logical Disk", SystemPDHCollector.class.getName());
            this.getPluginData().addPlugin("collector", SystemPlugin.BLOCK_DEVICE_SERVICE, LinuxCollector.class.getName());
        }
        try {
            return super.getNewCollector();
        }
        catch (MetricInvalidException ex) {
            this.getLog().debug((Object)("[getNewCollector] " + ex.getMessage()), (Throwable)ex);
            throw ex;
        }
    }
}

