/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.hq.agent.AgentLifecycle;
import org.hyperic.util.StringUtil;
import org.hyperic.util.file.FileUtil;
import org.tanukisoftware.wrapper.WrapperManager;

public class AgentUpgradeManager {
    private static final Log log = LogFactory.getLog(AgentUpgradeManager.class);
    public static final String UPDATED_PLUGIN_EXTENSION = "-update";
    public static final String REMOVED_PLUGIN_EXTENSION = "-remove";
    private static AtomicReference<Thread> agentDaemonThread = new AtomicReference();
    private static AtomicReference<AgentLifecycle> agent = new AtomicReference();

    public static void setAgentDaemonThread(Thread thread) {
        agentDaemonThread.set(thread);
    }

    public static void setAgent(AgentLifecycle runnableAgent) {
        agent.set(runnableAgent);
    }

    public static void restartJVM() {
        if (WrapperManager.isControlledByNativeWrapper()) {
            log.info((Object)"restart requested");
            WrapperManager.restartAndReturn();
            AgentUpgradeManager.stopAgent();
        }
    }

    public static void stopJVM(int exitCode) {
        if (WrapperManager.isControlledByNativeWrapper()) {
            log.info((Object)"stop requested");
            WrapperManager.stop((int)exitCode);
            AgentUpgradeManager.stopAgent();
        } else {
            System.exit(exitCode);
        }
    }

    private static void stopAgent() {
        if (agent.get() != null) {
            agent.get().shutdown();
        }
        if (agentDaemonThread.get() != null) {
            try {
                if (agentDaemonThread.get().isAlive()) {
                    agentDaemonThread.get().interrupt();
                    agentDaemonThread.get().join(30000L);
                }
                if (agentDaemonThread.get().isAlive()) {
                    log.error((Object)"AgentDaemonThread did not die within 30 seconds");
                }
            }
            catch (InterruptedException e) {
                log.debug((Object)e, (Throwable)e);
            }
        }
    }

    public static boolean upgrade(String newBundle) throws IOException {
        return AgentUpgradeManager.upgradePropertiesFile(newBundle);
    }

    private static boolean upgradePropertiesFile(String newBundle) throws IOException {
        Properties props = AgentUpgradeManager.getRollbackProperties();
        String oldBundle = AgentUpgradeManager.getCurrentBundle(props);
        AgentUpgradeManager.setCurrentBundle(props, newBundle);
        AgentUpgradeManager.setRollbackBundle(props, oldBundle);
        return AgentUpgradeManager.safeWriteRollbackProperties(props);
    }

    public static boolean rollback() throws IOException {
        return AgentUpgradeManager.rollbackPropertiesFile();
    }

    private static boolean rollbackPropertiesFile() throws IOException {
        Properties props = AgentUpgradeManager.getRollbackProperties();
        String rollbackHome = AgentUpgradeManager.getRollbackBundle(props);
        AgentUpgradeManager.setCurrentBundle(props, rollbackHome);
        return AgentUpgradeManager.safeWriteRollbackProperties(props);
    }

    private static String getCurrentBundle(Properties props) {
        return props.getProperty("set.HQ_AGENT_BUNDLE");
    }

    private static void setCurrentBundle(Properties props, String bundleHome) {
        props.setProperty("set.HQ_AGENT_BUNDLE", bundleHome);
    }

    private static String getRollbackBundle(Properties props) {
        return props.getProperty("set.HQ_AGENT_ROLLBACK_BUNDLE");
    }

    private static void setJavaHome(Properties props, String javaHome) {
        props.setProperty("set.HQ_JAVA_HOME", javaHome);
    }

    private static void setRollbackBundle(Properties props, String rollbackHome) {
        props.setProperty("set.HQ_AGENT_ROLLBACK_BUNDLE", rollbackHome);
    }

    private static String getRollbackPropertiesFile() {
        return System.getProperty("agent.rollbackPropFile", AgentConfig.DEFAULT_ROLLBACKPROPFILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getRollbackProperties() throws IOException {
        Properties props = new Properties();
        FileInputStream fis = null;
        String propFileName = AgentUpgradeManager.getRollbackPropertiesFile();
        File propFile = new File(propFileName);
        try {
            fis = new FileInputStream(propFile);
            props.load(fis);
        }
        catch (Throwable throwable) {
            FileUtil.safeCloseStream(fis);
            throw throwable;
        }
        FileUtil.safeCloseStream((InputStream)fis);
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean safeWriteRollbackProperties(Properties props) throws IOException {
        FileOutputStream fos = null;
        String propFileName = AgentUpgradeManager.getRollbackPropertiesFile();
        File propFile = new File(propFileName);
        File tempPropFile = new File(propFileName + ".tmp");
        try {
            try {
                tempPropFile.delete();
                fos = new FileOutputStream(tempPropFile);
                props.store(fos, "Properties for agent bundle versioning");
            }
            catch (Throwable throwable) {
                FileUtil.safeCloseStream(fos);
                throw throwable;
            }
            FileUtil.safeCloseStream((OutputStream)fos);
            boolean bl = FileUtil.safeFileMove((File)tempPropFile, (File)propFile);
            return bl;
        }
        finally {
            tempPropFile.delete();
        }
    }

    public static List<String> updatePlugins(Properties bootProps) throws IOException {
        ArrayList<String> updatedPlugins = new ArrayList<String>();
        String tmpDir = bootProps.getProperty(AgentConfig.PROP_TMPDIR[0]);
        String pluginsDir = bootProps.getProperty(AgentConfig.PROP_PDK_PLUGIN_DIR[0]);
        String[] children = new File(tmpDir).list();
        if (children != null) {
            for (String element : children) {
                if (element.indexOf(REMOVED_PLUGIN_EXTENSION) <= 0) continue;
                AgentUpgradeManager.removePlugin(element, tmpDir, pluginsDir, updatedPlugins);
            }
            for (String element : children) {
                if (element.indexOf(UPDATED_PLUGIN_EXTENSION) <= 0) continue;
                AgentUpgradeManager.movePlugin(element, tmpDir, pluginsDir, updatedPlugins);
            }
        }
        return updatedPlugins;
    }

    private static void removePlugin(String child, String tmpDir, String pluginsDir, List<String> updatedPlugins) {
        String fileName = StringUtil.remove((String)child, (String)REMOVED_PLUGIN_EXTENSION);
        File tmpJar = new File(tmpDir + "/" + child);
        File targetJar = new File(pluginsDir + "/" + fileName);
        targetJar.delete();
        log.info((Object)("Removed plugin: " + targetJar.toString()));
        tmpJar.delete();
    }

    private static void movePlugin(String child, String tmpDir, String pluginsDir, List<String> updatedPlugins) throws IOException {
        File targetJar;
        String fileName = StringUtil.remove((String)child, (String)UPDATED_PLUGIN_EXTENSION);
        File tmpJar = new File(tmpDir + "/" + child);
        boolean rslt = FileUtil.safeFileMove((File)tmpJar, (File)(targetJar = new File(pluginsDir + "/" + fileName)));
        if (!rslt) {
            throw new IOException("Failed to update plugin: " + fileName);
        }
        updatedPlugins.add(fileName);
    }
}

