/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.common.shared;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProductProperties {
    private static final String PROP_VERSION = "version";
    private static final String PROP_BUILD_DATE = "build.date";
    private static final String PROP_BUILD_NUMBER = "build.number";
    private static final String PROP_FLAVOUR = "hq.flavour";
    private static Properties _props;
    private static final Object _propsLock;

    private ProductProperties() {
    }

    public static String getVersion() {
        return ProductProperties.getRequiredProperty(PROP_VERSION);
    }

    public static String getBuildDate() {
        return ProductProperties.getRequiredProperty(PROP_BUILD_DATE);
    }

    public static String getFlavour() {
        return ProductProperties.getRequiredProperty(PROP_FLAVOUR);
    }

    public static String getBuildNumber() {
        String build = ProductProperties.getRequiredProperty(PROP_BUILD_NUMBER);
        Pattern p = Pattern.compile("(.*-)(\\d+)");
        Matcher m = p.matcher(build);
        if (m.matches()) {
            if (build.toLowerCase().contains("ci")) {
                return "CI-" + m.group(2);
            }
            if (build.toLowerCase().contains("daily")) {
                return "Daily-" + m.group(2);
            }
            return m.group(2);
        }
        return build;
    }

    private static void load(String name, boolean required) {
        InputStream in = ProductProperties.class.getClassLoader().getResourceAsStream(name);
        if (in == null) {
            if (required) {
                throw new IllegalStateException("Package not packed correctly, missing: " + name);
            }
            return;
        }
        try {
            _props.load(in);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read " + name + ": " + e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ignore) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties() {
        Object object = _propsLock;
        synchronized (object) {
            if (_props == null) {
                _props = new Properties();
                ProductProperties.load("hq-version.properties", false);
                ProductProperties.load("product.properties", false);
            }
        }
        return _props;
    }

    public static String getProperty(String key) {
        return ProductProperties.getProperties().getProperty(key);
    }

    private static String getRequiredProperty(String prop) {
        String res = ProductProperties.getProperty(prop);
        if (res == null) {
            throw new IllegalStateException("Failed to find " + prop);
        }
        return res;
    }

    static {
        _propsLock = new Object();
    }
}

