/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.control.agent.commands;

import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.AgentRemoteValue;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.EncodingException;
import org.hyperic.util.encoding.Base64;

public class ControlPluginAdd_args
extends AgentRemoteValue {
    private static final String PARAM_CONFIG = "config";
    private static final String PARAM_TYPE = "type";
    private static final String PARAM_NAME = "name";

    public ControlPluginAdd_args() {
    }

    public ControlPluginAdd_args(AgentRemoteValue args) throws AgentRemoteException {
        ConfigResponse config;
        String configStr = args.getValue(PARAM_CONFIG);
        String type = args.getValue(PARAM_TYPE);
        String name = args.getValue(PARAM_NAME);
        try {
            config = ConfigResponse.decode((byte[])Base64.decode((String)configStr));
        }
        catch (EncodingException e) {
            throw new AgentRemoteException("Unable to decode plugin configuration: " + e.getMessage());
        }
        if (type == null) {
            throw new AgentRemoteException("Plugin type not given");
        }
        if (name == null) {
            throw new AgentRemoteException("Plugin name not given");
        }
        this.setConfig(name, type, config);
    }

    public void setConfig(String name, String type, ConfigResponse config) throws AgentRemoteException {
        String configStr;
        try {
            configStr = Base64.encode((byte[])config.encode());
        }
        catch (EncodingException e) {
            throw new AgentRemoteException("Unable to encode plugin configuration: " + e.getMessage());
        }
        super.setValue(PARAM_CONFIG, configStr);
        super.setValue(PARAM_TYPE, type);
        super.setValue(PARAM_NAME, name);
    }

    public ConfigResponse getConfigResponse() throws AgentRemoteException {
        ConfigResponse config;
        String configStr = this.getValue(PARAM_CONFIG);
        try {
            config = ConfigResponse.decode((byte[])Base64.decode((String)configStr));
        }
        catch (EncodingException e) {
            throw new AgentRemoteException("Unable to decode plugin configuration: " + e.getMessage());
        }
        return config;
    }

    public String getType() {
        return this.getValue(PARAM_TYPE);
    }

    public String getName() {
        return this.getValue(PARAM_NAME);
    }
}

