/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.measurement;

public final class TimingVoodoo {
    public static long roundDownTime(long approxTime, long interval) {
        return TimingVoodoo.roundDownTime(approxTime, interval, 0L);
    }

    public static long roundDownTime(long approxTime, long interval, long offset) {
        return approxTime - approxTime % interval + offset;
    }

    public static long roundUpTime(long approxTime, long interval) {
        return approxTime + (interval - approxTime % interval);
    }

    public static long closestTime(long approxTime, long interval) {
        long mod = approxTime % interval;
        if (mod > interval / 2L) {
            approxTime += interval;
        }
        return approxTime - mod;
    }

    public static long[] current(long approxTime, long interval) {
        long[] retval = new long[2];
        long offset = Math.round((double)interval * 0.1);
        retval[0] = approxTime - offset;
        retval[1] = approxTime + offset;
        return retval;
    }

    public static long[] previous(long approxTime, long interval, int backTicks) {
        long[] retval = new long[3];
        long offset = Math.round((double)interval * 0.1);
        retval[2] = approxTime - (long)backTicks * interval;
        retval[0] = retval[2] - offset;
        retval[1] = retval[2] + offset;
        return retval;
    }

    public static long[] aggregate(long approxTime, long interval, int backTicks) {
        long[] retval = new long[2];
        long offset = Math.round((double)interval * 0.1);
        retval[0] = approxTime - (long)backTicks * interval - offset;
        retval[1] = approxTime + offset;
        return retval;
    }

    public static long percOfInterval(long interval) {
        return Math.round((double)interval * 0.1);
    }

    private TimingVoodoo() {
    }
}

